#!/bin/bash

set -euo pipefail

usage() {
    echo "Usage: $0 [OPTIONS]"
    echo ""
    echo "Options:"
    echo "  --with-model-data      Run compilation with model data instead of random data"
    echo "  --output-dir DIR       Custom output directory (default: /everest/ppsdv_cases_nobkup/\$USER/logs/model_compilation_<timestamp>)"
    echo "  --model-filter PATTERN Filter models by name pattern (glob-style, e.g., 'psd*' or 'Intel_bert')"
    echo "  -h, --help             Show this help message"
    exit 0
}

WITH_MODEL_DATA=""
OUTPUT_DIR=""
MODEL_FILTER=""

while [[ $# -gt 0 ]]; do
    case "$1" in
        --with-model-data)
            WITH_MODEL_DATA="--with-model-data"
            shift
            ;;
        --output-dir)
            OUTPUT_DIR="$2"
            shift 2
            ;;
        --model-filter)
            MODEL_FILTER="--model-filter $2"
            shift 2
            ;;
        -h|--help)
            usage
            ;;
        *)
            echo "Unknown option: $1"
            usage
            ;;
    esac
done

if [[ -z "$OUTPUT_DIR" ]]; then
    OUTPUT_DIR="/everest/ppsdv_cases_nobkup/$USER/logs/model_compilation_$(date +%Y%m%d_%H%M%S)"
fi

mkdir -p "$OUTPUT_DIR"

cd "$AIE4_ROOT_DIR/ci" || exit 1

# output_dir = location to store logs
# output_root = location to store aie4 Output folder
bash run_lsf_tests.sh \
    --job-prefix "model_$(date +%Y%m%d_%H%M%S)" \
    --output-dir "$OUTPUT_DIR" \
    --model-compilation \
    --output-root "$OUTPUT_DIR/OutputRoot" \
    $WITH_MODEL_DATA \
    $MODEL_FILTER \
    2>&1 | tee "$OUTPUT_DIR/compilation_output.log"