"""Tests for L2L3 allocator"""
import os
import pytest
from aie4_bench.common import patch_alloc_json, generate_alloc_json


CURRDIR = os.path.dirname(os.path.abspath(__file__))


@pytest.mark.e2e_model_bench
@pytest.mark.xdist_group("serial")
def test_yolov3():
    """Benchmark YoloV3 end-to-end"""
    # Generate allocation JSON
    _, alloc_data = generate_alloc_json(model_path=os.path.join(
        CURRDIR, "../graph/yolov3/YoloV3_INT8_Model_subgraph_cleaned_int8.onnx"))

    # Patch the json
    _ = patch_alloc_json(alloc_data, {
        "Add": "Add_qdq_EleWise_uint8xuint8xuint8",
        "Conv": "conv_noqdq_a8w8"
    })
