'''This script will load all the OperatorsRegistry configs from all modules'''
import importlib
import pkgutil
import warnings


def load_operators() -> None:
    '''Automatically import all modules in the 'buildscripts' directory'''
    package_name = __name__  # 'operators'
    for _, module_name, _ in pkgutil.iter_modules(__path__):
        module = importlib.import_module(f"{package_name}.{module_name}")
        if hasattr(module, "register"):  # Call register() if it exists
            module.register()
        elif module_name != 'common':
            warnings.warn(F"WARNING: {module_name} DOES NOT \
                HAVE FUNCTION `regsiter` WITH `OperatorsRegistry`!")


load_operators()
