# Commands to run regression tests

Following scripts are currently supported:

```bash
test_binary.py
test_broadcast.py
test_conv.py
test_gap.py
test_gemm.py
test_maxpool.py
test_pdi.py
test_resize.py
test_uniop.py
```

Use

```bash
python <script_name> --help
```

to understand the command line arguments supported by the script.

Example:

```bash
python test_conv.py --help
```

will produce

```
 Usage: test_conv.py [OPTIONS]

 Function for running conv regression testing using build script

╭─ Options ──────────────────────────────────────────────────────────────────────────────────────────────╮
│ --target               [dataflow|sim|cert_sim|cert]  Build target for the operator [default: dataflow] │
│ --dataflow-type        [l2|l3]                       Dataflow type [default: l2]                       │
│ --shape-index          INTEGER                       Index of the shape to test                        │
│ --vcd                                                Dump VCD trace [default: no-vcd]                  │
│ --hwtest                                             Run HW_test after builds [default: no-hwtest]     │
│ --clean                                              Clean output directory before running             │
│ --output-root          TEXT                          Root directory for output                         │
│ --help                                               Show this message and exit.                       │
╰────────────────────────────────────────────────────────────────────────────────────────────────────────╯
```

---

## Conv

### To target a specific shape

Example:

```bash
python test_conv.py --target sim --dataflow-type l2 --shape-index 1
python test_conv.py --target sim --dataflow-type l3 --shape-index 1
```

### To run a regression for all shapes

Example:

```bash
python test_conv.py --target sim --dataflow-type l2
python test_conv.py --target sim --dataflow-type l3
```

### To specify custom output directory

Example:

```bash
python test_conv.py --target sim --dataflow-type l2 --output-root /tmp/my_outputs
```

**Note:** When running tests directly with Python (e.g., `python test_conv.py`), the `--output-root` path is used as-is. Template variables like `{{worker_id}}` and `{{uuid}}` are only expanded when running through pytest (see PyTest User Guide for details).

### Common Options Available Across All Tests

All test scripts support these common options:

- `--target` - Build target: `dataflow` (default), `sim`, `cert_sim`, or `cert`
- `--shape-index` - Run a specific shape by index (omit to run all shapes)
- `--hwtest` - Run hardware validation after building (requires hardware setup)
- `--clean` - Clean the output directory before running tests
- `--output-root` - Specify custom output directory (default: `../Output`)
- `--vcd` - Dump VCD trace for simulation (sim target only)

Example with multiple options:

```bash
python test_conv.py --target cert --shape-index 0 --clean --hwtest --output-root /tmp/conv_test
```

---

## GEMM

### To target a specific shape

Example:

```bash
python test_gemm.py --data-type uint16 --gemm-mode act_t --transpose-wgts 1 --dataflow-type l3 --target sim --shape-index 0
```

### To run a regression for all shapes

Example:

```bash
python test_gemm.py --data-type uint16 --gemm-mode act_t  --transpose-wgts 1 --dataflow-type l3 --target sim
```

---

## Binary

### To target a specific shape

Example:

```bash
python test_binary.py --operator add-8 --target sim --shape-index 1
```

### To run a regression for all shapes

Example:

```bash
python test_binary.py --operator add-8 --target sim
```

## Broadcast

### Supported Operators

- add_uint8
- add_int8
- add_uint16
- add_int16
- mul_uint16
- mul_int16

### Command-line Options

- `--operator`: Specify the broadcast operator (required)
- `--target`: Build target [dataflow|sim|cert_sim|cert] (default: dataflow)
- `--shape-index`: Index of the shape to test
- `--disable-dq0`: Disable DQ0 (flag)
- `--disable-q`: Disable Q (flag)

### To target a specific shape

Example:

```bash
python test_broadcast.py --operator add_uint8 --target sim --shape-index 1
```/

### To run a regression for all shapes:

Example:

```bash
python test_broadcast.py --operator add_uint8 --target sim
```

---

## Maxpool

### To target a specific shape

Example:

```bash
python test_maxpool.py --target sim --shape-index 1
```

### To run a regression for all shapes

Example:

```bash
python test_maxpool.py --target sim
```

---

## Unitary-ops (Softmax / l2norm / Silu)

### To target a specific shape

```bash
python test_uniop.py --shape-index 0
```

---

## PDI

### Selecting Target DType (int8 or int16)

You can specify the target data type when running `test_pdi.py` using the `--data-type` option.

#### **Usage**

```bash
python test_pdi.py --data-type [int8(default) | int16]
```

#### **Example:**

```bash
# Compile for int8 operators (default)
python test_pdi.py --data-type int8

# Compile for int16 operators
python test_pdi.py --data-type int16
```

---

## Resize (NNI)

### To target a specific shape

Example:

```bash
python test_resize.py --target sim --shape-index 1
```

### To run a regression for all shapes

python test_resize.py --target [dataflow(default) | sim | cert_sim | cert]

Example:

```bash
python test_resize.py --target sim
```

### To run HW test

Example:

```bash
python test_conv.py --target cert --dataflow-type l3 --shape-index 1 --hwtest
python test_gemm.py --target cert  --dataflow-type l3 --data-type int8 --gemm-mode wgt --hwtest --clean
```

---
