#!/bin/bash
echo "Running: $*"

# Find git repository root
REPO_DIR=$(git rev-parse --show-toplevel 2>/dev/null)
if [[ -z "$REPO_DIR" ]]; then
    echo "Error: Not in a git repository" >&2
    exit 1
fi
echo "Repository root: $REPO_DIR"

# Change to repository root
if ! cd "$REPO_DIR"; then
    echo "Error: Failed to change to repository directory: $REPO_DIR" >&2
    exit 1
fi
echo "Changed to directory: $(pwd)"

# Source environment setup
if [[ ! -f "$REPO_DIR/settings.sh" ]]; then
    echo "Error: settings.sh not found in $REPO_DIR" >&2
    exit 1
fi
source "$REPO_DIR/settings.sh" || true
echo "Sourced settings.sh"

# Activate virtual environment
if [[ ! -f "$REPO_DIR/env/bin/activate" ]]; then
    echo "Error: Virtual environment not found at $REPO_DIR/env/bin/activate" >&2
    exit 1
fi
source "$REPO_DIR/env/bin/activate"
echo "Activated virtual environment"

# Verify command was provided
if [[ $# -eq 0 ]]; then
    echo "Error: No command provided" >&2
    exit 1
fi

# Print debug info
echo "Working directory: $(pwd)"
echo "Python: $(which python)"
echo "Python version: $(python --version)"
echo "Running: $*"
echo "---"

# Run the command
"$@"
