'''
Generate PDI
'''
import os
import typer

from common import change_dir, BuildTarget
from build_aie4 import compile_operator, get_combined_kernel_from_ops
from graph.utilities import config_logger_from_env
from buildtest.common import Counter

CURRDIR = os.path.dirname(os.path.abspath(__file__))
config_logger_from_env()
pdi_counter = Counter()


LIST_OPS = ["Add_qdq_EleWise_uint16xuint16xuint16"]


def main(
    target: BuildTarget = typer.Option(default=BuildTarget.DATAFLOW, help="Build target for the operator"),
    vcd: bool = typer.Option(default=False, help="Dump VCD trace", is_flag=True),
    output_root: str = typer.Option(default=os.path.join(CURRDIR, "..", "Output"), help="Root directory for output")
) -> None:
    '''Function for generating PDI using build script'''
    is_cert_backend = target == BuildTarget.CERT
    gen_pdi = is_cert_backend and pdi_counter() == 1

    combined_kernel_includes, combined_kernel_names = get_combined_kernel_from_ops(LIST_OPS)

    shape = {"input": [0]}
    output_root = str(output_root)
    with change_dir("../"):
        os.environ["LOG_ENABLED"] = "true"
        compile_operator("pdi", shape, target, output_root,
                         combined_kernel_includes=combined_kernel_includes,
                         combined_kernel_names=combined_kernel_names,
                         gen_standalone_pdi=gen_pdi,
                         gen_op_elf=is_cert_backend, dump_vcd=vcd)


if __name__ == '__main__':
    typer.run(main)
