import json
import os
from typing import List
from collections import namedtuple


CfgItem = namedtuple("CfgItem", ["id", "path"])


def generate_aiebu_json(cfg: List[CfgItem], out_path: str) -> None:
    """
    Generate a JSON file for xrt-kernels with one or multiple control.asm instances.

    Args:
        cfg (List[CfgItem]): List of namedtuples containing (id, path).
        out_path (str): File path to write the JSON output.
    """
    instances = [
        {
            "id": id_str,
            "ctrl_code_file": os.path.join(path, "control.asm")
        }
        for id_str, path in cfg
    ]

    data = {
        "xrt-kernels": [
            {
                "name": "DPU",
                "arguments": [
                    {"name": "arg0", "type": "char *", "offset": "0x00"},
                    {"name": "arg1", "type": "char *", "offset": "0x08"},
                    {"name": "arg2", "type": "char *", "offset": "0x10"},
                    {"name": "arg3", "type": "char *", "offset": "0x18"},
                ],
                "instance": instances
            }
        ]
    }

    with open(out_path, "w", encoding="utf-8") as f:
        json.dump(data, f, indent=4)
