'''
Script to extract error metric prints from AIESimulator.log for Unary op
'''

import os


def get_subfolder_names(path):
    """ Return list of subfolder names under the given path """

    # List all entries in the directory
    entries = os.listdir(path)

    # Filter only directories
    subfolders = [entry for entry in entries if os.path.isdir(os.path.join(path, entry))]

    return subfolders


def scan_files_for_prefix(file_path, set_of_prefix):
    """ Extract error metric prints from AIESimulator.log """
    try:
        with open(file_path, 'r', encoding='utf-8') as f:
            for line in f:
                for line_prefix in set_of_prefix:
                    if line.startswith(line_prefix):
                        print(f"{file_path[:20]}: {line.strip()}")

    except FileNotFoundError:
        print(f"Error reading {file_path}")


set_prefix = {
              "total_number_elements:",
              "Root Mean square Error ",
              "Max Error ",
              "Mean Absolute Error",
              "Average Relative Error Percentage ",
              "Error Count ",
              "Max Relative Error Percentage "
            }

# Example usage
Output_folder = "./Output/"
op_folders = get_subfolder_names(Output_folder)

for op_folder in op_folders:
    scan_files_for_prefix(Output_folder + op_folder + "/AIESimulator.log", set_prefix)
    print("======================================================================================================")
