# Graph Module Overview

The Graph module provides memory allocation and scheduling for tensor operations in AI Engine models.

## Quick Start

```python
from graph.allocation_types import AllocationConfig, AllocationStrategy, MemoryBlock
from graph.multibin_allocator import MultiBinGraphMemoryScheduler

# Configure allocator
config = AllocationConfig(strategy=AllocationStrategy.FIRST_FIT)
blocks = [MemoryBlock(start=0, size=2048, is_free=True)]

# Create scheduler
scheduler = MultiBinGraphMemoryScheduler.build([(config, blocks)])
```

For complete examples, see [test_multibin_allocator.py](https://gitenterprise.xilinx.com/IPSP/aie4_models/blob/main/graph/tests/test_multibin_allocator.py).

## Usage Examples

See the test files for comprehensive examples:

- `graph/tests/test_multibin_allocator.py` - Multi-bin scheduling
- `graph/tests/test_tensor_memory_allocator.py` - Single-bin allocation
- `graph/tests/test_base_memory_allocator.py` - Base allocation strategies
