# Contributing

For complete contributing guidelines, please see the main [CONTRIBUTING.md](https://gitenterprise.xilinx.com/IPSP/aie4_models/blob/main/CONTRIBUTING.md) in the repository root.

This page provides quick reference for documentation-specific contributions.

## Documentation Development

### Building Documentation

```bash
# Serve locally with auto-reload
mkdocs serve

# Build static site
mkdocs build

# Deploy to GitHub Pages (if configured)
mkdocs gh-deploy
```

### Documentation Structure

- `docs/index.md` - Home page
- `docs/guide/` - User guides and tutorials
- `docs/api/` - API reference documentation
- `mkdocs.yml` - Documentation configuration

## Writing API Documentation

### Docstrings

Use Google-style docstrings for automatic API documentation generation:

```python
def allocate(self, allocation: TensorAllocation) -> bool:
    """Allocate memory for a tensor.

    Args:
        allocation: Tensor allocation request containing tensor metadata,
            lifetime range, and memory location preferences.

    Returns:
        True if allocation succeeded, False otherwise.

    Raises:
        ValueError: If tensor is already allocated.
        AssertionError: If tensor bin doesn't match allocator bin.
    """
    ...
```

### Adding New API Pages

- Create a new `.md` file in `docs/api/graph/` or `docs/api/tiler/`
- Use the `:::` syntax to include Python module documentation:

```markdown
# My Module

::: graph.my_module.MyClass
    options:
      show_source: true
      members: true
```

- Add the page to `mkdocs.yml` navigation

## Testing & Code Style

For testing guidelines, code style standards, and linting requirements, see the main [CONTRIBUTING.md](https://gitenterprise.xilinx.com/IPSP/aie4_models/blob/main/CONTRIBUTING.md).
