# AIE4 Models Documentation

Welcome to the **AIE4 Models** API documentation. This documentation focuses on the Graph module for memory allocation and scheduling.

For general information about the project, building operators, and getting started, please see the main [README](https://gitenterprise.xilinx.com/IPSP/aie4_models/blob/main/README.md).

## Overview

AIE4 Models consists of several key components:

- **Graph Module**: Memory allocation and scheduling for tensor operations
- **Tiler Module**: Kernel tiling and metadata management for AI Engine operations
- **Scheduler Module**: Operation scheduling and optimization
- **Graph Partitioner**: ONNX graph partitioning for NPU/CPU execution

## Documentation Structure

- [Getting Started](guide/getting-started.md) - Quick start with Graph API examples
- [Graph API](api/graph/index.md) - Detailed API reference for memory allocation
- [Contributing](contributing.md) - Documentation contribution guidelines

For complete project setup, building, and contributing guidelines, see [README](https://gitenterprise.xilinx.com/IPSP/aie4_models/blob/main/README.md) and [CONTRIBUTING.md](https://gitenterprise.xilinx.com/IPSP/aie4_models/blob/main/CONTRIBUTING.md).

## Getting Help

- Check the [Graph API Reference](api/graph/index.md) for detailed API documentation
- Review test files in `graph/tests/` for comprehensive usage examples
- See main [README](https://gitenterprise.xilinx.com/IPSP/aie4_models/blob/main/README.md) for project overview and build instructions
- See [CONTRIBUTING.md](https://gitenterprise.xilinx.com/IPSP/aie4_models/blob/main/CONTRIBUTING.md) for development workflow and guidelines
