#pragma once
#include <iostream>
#include <cstdio>
#include <cstdarg>

#ifdef ASM_MODE

// ----- Null sink for iostreams -----
struct NullBuffer : public std::streambuf {
    int overflow(int c) override { return c; }  // drop chars
};
inline NullBuffer __nullbuf;
inline std::streambuf* __old_cout = nullptr;
inline std::streambuf* __old_clog = nullptr;

// Redirect cout/clog at program start; restore on exit
struct __MuteStdoutLogs {
    __MuteStdoutLogs() {
        __old_cout = std::cout.rdbuf(&__nullbuf);
        __old_clog = std::clog.rdbuf(&__nullbuf);
    }
    ~__MuteStdoutLogs() {
        if (__old_cout) std::cout.rdbuf(__old_cout);
        if (__old_clog) std::clog.rdbuf(__old_clog);
    }
};
inline __MuteStdoutLogs __mute_stdout_logs_singleton;

// ----- C stdio: keep stderr visible -----
#define printf(...) ((void)0)

// Keep fprintf(stderr, ...) working; drop only stdout
inline int __fprintf_keep_stderr(FILE* f, const char* fmt, ...) {
    if (f == stdout) return 0;
    va_list ap; va_start(ap, fmt);
    const int r = vfprintf(f, fmt, ap);
    va_end(ap);
    return r;
}
#define fprintf(stream, ...) __fprintf_keep_stderr((stream), __VA_ARGS__)

#endif // ASM_MODE
