#ifndef GAP_HPP
#define GAP_HPP

#include <random>
#include "common.hpp"

inline void init_random_globalavgpool_a8(ActTensor<int8_t> pIn, int64_t min = -4, int64_t max = 4)
{
    for (int c = 0; c < pIn.C; ++c) {
        for (int y = 0; y < pIn.Y; ++y) {
            for (int x = 0; x < pIn.X; ++x) {
                if (std::is_integral<int8_t>::value) {
                    pIn.at(c, y, x) = static_cast<int8_t>((rand() % (max - min)) + min);
                } else {
                    pIn.at(c, y, x) = static_cast<int8_t>(static_cast<float>(max - min) * (static_cast<float>(rand()) / static_cast<float>(RAND_MAX)) + min);
                }
            }
        }
    }
}

inline void cpu_globalavgpool_a8(ActTensor<int8_t> pIn, ActTensor<int8_t> pOut, int shift, int scale ) {
    for (int c = 0; c < pIn.C; ++c) {
        int32_t acc = 0;
        for (int y = 0; y < pIn.Y; ++y) {
            for (int x = 0; x < pIn.X; ++x) {
                acc += scale * pIn.at(c, y, x);
            }
        }
        pOut.at(c, 0, 0) = static_cast<int8_t>((acc) >> shift);
    }
}


#endif // GAP_HPP