#ifndef RESIZE_HPP
#define RESIZE_HPP

#include <assert.h>
#include <stdlib.h>
#include <iostream>
#include <random>

template <typename ElemT>
void rand_tensor(ActTensor<ElemT>& tensor, int min = -32768, int max = 32767, bool fixed = 0)
{
    std::default_random_engine gen;
    std::uniform_int_distribution<int16_t> ui_distribution(min, max);
     for(int i = 0; i < tensor.Y; ++i) {
        for (int j = 0; j < tensor.X; ++j) {
            for (int k = 0; k < tensor.C; ++k) {
                if (fixed)
                    tensor.at(k, i, j) = ui_distribution(gen);
                else
                    tensor.at(k, i, j) = float_to_bfloat16(2.0 * (rand() / (float) RAND_MAX) - 1.0).value;
            }
        }
    }

}


template<typename T>
void cpu_nni(
    ActTensor<T> input_tensor,
    ActTensor<T> output_tensor,
    int num_interpolations_h,
    int num_interpolations_w
)
{
    for (int h = 0; h < input_tensor.Y * num_interpolations_h; ++h) {
        for (int w = 0; w < input_tensor.X * num_interpolations_w; ++w) {
            for (int c = 0; c < input_tensor.C; ++c) {
                int i, j, k;
                if (h % num_interpolations_h != 0 && w % num_interpolations_w == 0) {
                    i = h - 1;
                    j = w;
                    k = c;
                } else if (h % num_interpolations_h == 0 && w % num_interpolations_w != 0) {
                    i = h;
                    j = w - 1;
                    k = c;
                } else if (h % num_interpolations_h != 0 && w % num_interpolations_w != 0) {
                    i = h - 1;
                    j = w - 1;
                    k = c;
                } else {
                    i = h;
                    j = w;
                    k = c;
                }
                i = i / num_interpolations_h;
                j = j / num_interpolations_w;
                k = k;
                output_tensor.at(c, h, w) = input_tensor.at(k, i, j);
            }
        }
    }
}
#endif // RESIZE_HPP