#include <string>
#include <sstream>
#include <fstream>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#if !ASM_MODE
#include <adf.h>
#include <adf/adf_api/AIERuntimeControl.h>
#include "super.hh"
#include "graph.hpp"
#endif // !ASM_MODE
#ifdef __AIESIM__
#if !ASM_MODE
#include "dma.hpp"
#endif // !ASM_MODE
#endif // __AIESIM__
#include "resize_nni.hpp"

#if !ASM_MODE
ComputeGraph g_compute_graph;
#endif // !ASM_MODE

int run_resize_nni_noqdq_a8(
    int const half_pixel, int const align_corner, int const asymmetric,
    int const Yo, int const Xo, int const Co,
    int const Yi, int const Xi, int const Ci,
    int const Yos, int const Xos, int const Cos,
    int const Yis, int const Xis, int const Cis,
    int const Yis_step, int const Xis_step,
    int const Yis_offset, int const Xis_offset,
    int const read_ifm, int const read_wgt
){
    using Ta = int8_t;
    using Tw = int8_t;
    using To = int8_t;
    bool read_mode_data = false;
    CoordinateTransformationMode mode;
    if (half_pixel) {
        mode = CoordinateTransformationMode::HalfPixel;
    } else if (align_corner) {
        mode = CoordinateTransformationMode::AlignCorners;
    } else if (asymmetric) {
        mode = CoordinateTransformationMode::Asymmetric;
    } else {
        printf("Invalid coordinate transformation mode\n");
    }
    int ifm_size = ActTensor<Ta>::size(Ci, Yi, Xi);
    int ofm_size = ActTensor<Ta>::size(Co, Yo, Xo);
    int wgt_size = ResizeNNIWGT<Tw>::size(Yo, Xo, Yos, Xos);
    printf("ifm_size = %d\n", ifm_size);
    printf("ofm_size = %d\n", ofm_size);
    printf("wgt_size = %d\n", wgt_size);

#if !ASM_MODE
    ActTensor<Ta> aie_ifm(
        Ci, Yi, Xi,
        adf::GMIO::malloc(ifm_size)
    );
    ResizeNNIWGT<Tw> aie_wgt(
        mode, Yo, Xo, Yi, Xi,
        Yos, Xos, Yis, Xis,
        Yis_step, Xis_step,
        Yis_offset, Xis_offset,
        false,
        adf::GMIO::malloc(wgt_size)
    );
    ActTensor<To> aie_ofm(
        Co, Yo, Xo,
        adf::GMIO::malloc(ofm_size)
    );
#else
    ActTensor<Ta> aie_ifm(
        Ci, Yi, Xi,
        malloc(ifm_size)
    );
    ResizeNNIWGT<Tw> aie_wgt(
        mode, Yo, Xo, Yi, Xi,
        Yos, Xos, Yis, Xis,
        Yis_step, Xis_step,
        Yis_offset, Xis_offset,
        false,
        malloc(wgt_size)
    );
#endif // !ASM_MODE
    aie_wgt.set_wgt();
    aie_wgt.print_raw_indices();
    ActTensor<To> cpu_ofm(
        Co, Yo, Xo,
        malloc(ofm_size)
    );
    init_randon_resize_nni(aie_ifm);

    std::string const ifm_bin_path = "../intermediate_bins/ifm1.bin";
    std::string const wgt_bin_path = "../intermediate_bins/wgt.bin";
    if (read_ifm) {
        read_bin_file(ifm_bin_path, reinterpret_cast<char*>(aie_ifm.data), ifm_size);
    }
    if (read_wgt) {
        read_bin_file(wgt_bin_path, reinterpret_cast<char*>(aie_wgt.data), wgt_size);
    }

    cpu_resize_nni(aie_ifm, aie_wgt, cpu_ofm);
#ifdef __AIESIM__
#if ASM_MODE
    write_bin_file("ifm.bin", (char*)aie_ifm.data, ifm_size);
    write_bin_file("wgt.bin", (char*)aie_wgt.data, wgt_size);
    write_bin_file("ofm.bin", (char*)cpu_ofm.data, ofm_size);
#else
    log_tensor(aie_ifm, "ifm");
    log_tensor(cpu_ofm, "cpu_ofm");
    g_compute_graph.init();
    run_dma_layer_config(g_compute_graph, aie_ofm.data, aie_ifm.data, aie_wgt.data);
    g_compute_graph.end();

    int epsilon = 1;
    int err = cmp_tensor(cpu_ofm, aie_ofm, 0, epsilon);
    if (err == 0)
        printf("RESIZE_NNI DI_PASS: Yi=%d, Xi=%d, Ci=%d, Yo=%d, Xo=%d, Co=%d \n", Yi, Xi, Ci, Yo, Xo, Co);
    else
        printf("RESIZE_NNI DI_FAIL: Yi=%d, Xi=%d, Ci=%d, Yo=%d, Xo=%d, Co=%d \n", Yi, Xi, Ci, Yo, Xo, Co);
#endif // ASM_MODE
#endif // __AIESIM__
#if !ASM_MODE
    adf::GMIO::free(aie_wgt.data);
    adf::GMIO::free(aie_ifm.data);
    adf::GMIO::free(aie_ofm.data);
#else
    free(aie_wgt.data);
    free(aie_ifm.data);
#endif // !ASM_MODE
    free(cpu_ofm.data);
    return 0;
}

int main(void) {
    int const half_pixel = HALF_PIXEL;
    int const align_corner = ALIGN_CORNERS;
    int const asymmetric = ASYMMETRIC;
    int const Co = COUT;
    int const Yo = YOUT;
    int const Xo = XOUT;
    int const Ci = CIN;
    int const Yi = YIN;
    int const Xi = XIN;
    int const Yos = YOS;
    int const Xos = XOS;
    int const Cos = COS;
    int const Yis = YIS;
    int const Xis = XIS;
    int const Cis = CIS;
    int const Yis_step = YIS_STEP;
    int const Xis_step = XIS_STEP;
    int const Yis_offset = YIS_OFFSET;
    int const Xis_offset = XIS_OFFSET;
    int const read_ifm = READ_IFM;
    int const read_wgt = READ_WGT;

     // check if only one coordinate transformation mode is set
    if (half_pixel + align_corner + asymmetric != 1) {
        printf("Error: no coordinate transformation mode is set.\n");
        return -1;
    }
    printf("half_pixel = %d\n", half_pixel);
    printf("align_corner = %d\n", align_corner);
    printf("asymmetric = %d\n", asymmetric);
    printf("IFM Dimensions: YIN x XIN x CIN = %d x %d x %d\n", Yi, Xi, Ci);
    printf("OFM Dimensions: YOUT x XOUT x COUT = %d x %d x %d\n", Yo, Xo, Co);
    printf("IFM subvolume Dimensions: YIS x XIS x CIS = %d x %d x %d\n", Yis, Xis, Cis);
    printf("OFM subvolume Dimensions: YOS x XOS x COS = %d x %d x %d\n", Yos, Xos, Cos);
    printf("IFM subvolume step: YIS_STEP x XIS_STEP = %d x %d\n", Yis_step, Xis_step);
    printf("IFM subvolume offset: YIS_OFFSET x XIS_OFFSET = %d x %d\n", Yis_offset, Xis_offset);

    run_resize_nni_noqdq_a8(
        half_pixel, align_corner, asymmetric,
        Yo, Xo, Co,
        Yi, Xi, Ci,
        Yos, Xos, Cos,
        Yis, Xis, Cis,
        Yis_step, Xis_step,
        Yis_offset, Xis_offset,
        read_ifm, read_wgt
    );
    return 0;
}
