#ifndef __KERNEL_SiLU_B16_EXP2_HPP__
#define __KERNEL_SiLU_B16_EXP2_HPP__

#include "stdint.h"

struct KernelSiLUExp2Param {
    uint32_t outer_g;
    float k0s;
    float k1s;
    float k2s;
    float k3s;
};

template<unsigned poly_order, unsigned loop_range, typename Ti, typename To>
ALWAYS_INLINE void SiLU_exp2
(
    Ti * restrict input,
    To * restrict output,
    float * restrict spill_buf_a,
    float * restrict spill_buf_b,
    const KernelSiLUExp2Param &params
);

struct sigelu_layer_param
{
    uint32_t input_addr;
    uint32_t output_addr;
    uint32_t spill_a_addr;
    uint32_t spill_b_addr;
    uint32_t qdq_param_addr;
    uint32_t dq_buffer_addr;
    uint32_t q_buffer_addr;
    uint32_t num_iters;
    float k0s;
    float k1s;
    float k2s;
    float k3s;
    uint32_t sign_A;
    uint32_t sign_O;
};
#endif //__KERNEL_SiLU_EXP2_HPP__