import struct


def float_to_bytes(value):
    return struct.pack('f', value)


def silu_layer_params(
    CoreInputAddr: int,
    CoreOutputAddr: int,
    CoreSpillAAddr: int,
    CoreSpillBAddr: int,
    QdqParamAddr: int,
    dqBufferAddr: int,
    qBufferAddr: int,
    num_iters: int,
    k0s: float,
    k1s: float,
    k2s: float,
    k3s: float,
    signA: int,
    signO: int
) -> bytes:

    CoreInputAddr += 0xE0000
    CoreOutputAddr += 0xE0000
    CoreSpillAAddr += 0xE0000
    CoreSpillBAddr += 0xE0000
    QdqParamAddr += 0xE0000
    dqBufferAddr += 0xE0000
    qBufferAddr += 0xE0000

    bytes = (
        CoreInputAddr.to_bytes(length=4, byteorder="little", signed=False)
        + CoreOutputAddr.to_bytes(length=4, byteorder="little", signed=False)
        + CoreSpillAAddr.to_bytes(length=4, byteorder="little", signed=False)
        + CoreSpillBAddr.to_bytes(length=4, byteorder="little", signed=False)
        + QdqParamAddr.to_bytes(length=4, byteorder="little", signed=False)
        + dqBufferAddr.to_bytes(length=4, byteorder="little", signed=False)
        + qBufferAddr.to_bytes(length=4, byteorder="little", signed=False)
        + num_iters.to_bytes(length=4, byteorder="little", signed=False)
        + float_to_bytes(k0s)
        + float_to_bytes(k1s)
        + float_to_bytes(k2s)
        + float_to_bytes(k3s)
        + signA.to_bytes(length=4, byteorder="little", signed=False)
        + signO.to_bytes(length=4, byteorder="little", signed=False)
    )
    # log("Number of bytes l2norm layer params:", len(bytes))
    return bytes
