#ifndef RUN_MATADD_INT8_WRAPPER_CC
#define RUN_MATADD_INT8_WRAPPER_CC

#include "add2d_int8x8_template.h"
#include "common.hh"
#include "q/q_impl.hpp"
#include "dq/dq_impl.hpp"

#pragma pack(push,1)
struct matadd8_layer_params{
    uint16_t num_elements;
    Add2dInt8x8Params add_params;
};
#pragma pack(pop)

void run_matadd_int8(KernelArgs& args)
{
    matadd8_layer_params* layer_params = static_cast<matadd8_layer_params*>(args.params_data);

    int8* matA = static_cast<int8*>(args.s2mm_ch0_port->data());
    int8* matB = byte_incr(matA, layer_params->num_elements);
    int8* output = static_cast<int8*>(args.mm2s_ch0_port->data());

    add2d_int8x8<false, 8, int8, int8, int8>(
        matA, matB, output, layer_params->add_params
    );
}
#endif