#ifndef __BDCAST_ADD2D_INT8x8_HPP__
#define __BDCAST_ADD2D_INT8x8_HPP__

#include "stdint.h"

struct bdcast_Add2dInt8x8Params {
    uint32_t outer_loop;
    dims_2d_param dims_x;
    dims_2d_param dims_y;
    int8_t shift_in;
    int8_t shift_in1;
    int8_t shift_res;
    struct Control {
        uint8_t sign_A:1;
        uint8_t sign_W:1;
        uint8_t sign_O:1;
        uint8_t sign_srs:1;
    } ctrl;
    uint8_t max_value;
};

template<bool has_relu6, unsigned use_mmac, unsigned has_scalar_broadcast, unsigned loop_range, typename Ti0, typename Ti1, typename To>
void bdcast_add2d_int8x8( Ti0 * ifm, Ti1 * wgt, To * __restrict ofm, const bdcast_Add2dInt8x8Params &params );

#endif