#ifndef __KERNEL_DIV_BF16X16_HPP__
#define __KERNEL_DIV_BF16X16_HPP__

#include "stdint.h"
#include "common.hh"

struct KernelDivBf16x16Param {
    uint32_t loop_count;
    dims_2d_param dims_x;
    dims_2d_param dims_y;
};

template<unsigned has_scalar_broadcast, typename Ti0, typename Ti1, typename To>
void div_bf16x16 ( 
    Ti0 * in0, 
    Ti1 * in1, 
    To  * __restrict ofm, 
    const KernelDivBf16x16Param &param 
);

#endif // __KERNEL_DIV_BF16X16_HPP__
