/*  (c) Copyright 2019 - 2022 Xilinx, Inc. All rights reserved.
    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.
    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.
    
    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.
    
    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __KERNEL_MUL_BF16x16_IMPL_HPP__
#define __KERNEL_MUL_BF16x16_IMPL_HPP__  

#include "broadcast/mul_bf16x16.hpp"
#include "aie_api/aie.hpp"
#include "aie_api/utils.hpp"
#include "stdio.h"

using namespace aie;

void mul_bf16x16_nontemplatized 
(
    unsigned has_scalar_broadcast,
    QDQFloatType * input,
    QDQFloatType * weights,
    QDQFloatType * __restrict output,
    const KernelMulBf16x16Param &params
){
    if (has_scalar_broadcast){
        mul_bf16x16<6, 1, QDQFloatType, QDQFloatType>(
            input, weights, output, params
        );
    } else {
        mul_bf16x16<6, 0, QDQFloatType, QDQFloatType>(
            input, weights, output, params
        );
    }
}

template<unsigned loop_range=6, unsigned has_scalar_broadcast=0, typename Ti=QDQFloatType, typename To=QDQFloatType>
ALWAYS_INLINE void mul_bf16x16 ( 
    Ti * in0, 
    Ti * in1, 
    To * __restrict ofm, 
    const KernelMulBf16x16Param &params
) {
    Ti * pI0 = in0;
    Ti * pI1 = in1;
    To * pO  = ofm;

    constexpr unsigned gran = 64;
    dims_2d_t dims_x = params.dims_x.instantiate( );
    dims_2d_t dims_y = params.dims_y.instantiate( );

    for ( unsigned j = 0; j < params.outer_loop; j++ )
        chess_prepare_for_pipelining
        chess_loop_range( loop_range, )
    {
        vector<Ti, gran> Xbuff;
        vector<Ti, gran> Ybuff;
        vector<To, gran> out;

        Xbuff = load_v<gran>( pI0 );
        if constexpr( has_scalar_broadcast == 1 ) {
            Ybuff = aie::broadcast<Ti, gran>( *(pI1) );
        } else {
            Ybuff = load_v<gran>( pI1 );
        }

        if constexpr( std::is_same_v<To, float16> ) {
            out = mul_elem_64( Xbuff, Ybuff );
        } else {
            out = mul_elem_64b( Xbuff, Ybuff );
        }

        store_v( pO, out ); 
        
        pI0 = add_2d_byte( pI0, dims_x );
        pI1 = add_2d_byte( pI1, dims_y );
        pO  += gran;
    }
}

#endif // __MUL_BF16x16_TEMPLATE_H__
