#ifndef RUN_BDCASTADD_INT8_WRAPPER_CC
#define RUN_BDCASTADD_INT8_WRAPPER_CC

#include "common.hh"
#include "aie_api/aie.hpp"
#include "add2d_int8x8_impl.hpp"
#include "q/q_impl.hpp"
#include "dq/dq_impl.hpp"
using namespace aie;

#pragma pack(push,1)
struct bdcast_add8_layer_params{
    uint32_t offset_bytes;
    uint32_t has_scalar_broadcast;
    bdcast_Add2dInt8x8Params add_params;
};
#pragma pack(pop)

void run_bdcastadd_8(KernelArgs& args)
{
    bdcast_add8_layer_params* layer_params = reinterpret_cast<bdcast_add8_layer_params*>(args.params_data);

    int8* matB = static_cast<int8*>(args.s2mm_ch0_port->data());
    int8* matA = byte_incr(matB, -layer_params->offset_bytes);
    int8* output = static_cast<int8*>(args.mm2s_ch0_port->data());


    if (layer_params->has_scalar_broadcast) {
        bdcast_add2d_int8x8<false, false, true, 8, int8, int8, int8>(
            matA, matB, output, layer_params->add_params
        );
    } else {
        bdcast_add2d_int8x8<false, false, false, 8, int8, int8, int8>(
            matA, matB, output, layer_params->add_params
        );
    }
}
#endif