#ifndef __ACCESS_HELPERS_HPP__
#define __ACCESS_HELPERS_HPP__

#include <type_traits>
#include "aie_api/aie.hpp"

template<class B>
struct buffer_element {
    using type = std::remove_reference_t<decltype( *((B*)nullptr)->data( ))>;
};
/*
template<>
struct buffer_element<adf::input_async {
    using type = std::remove_reference_t<decltype( *B().data( ))>;
};
*/
//template<class B>
//auto buffer_element_t( B b ) {
//    auto h = buffer_element_type( b );
//    return h::type;
//}
template<class B>
using buffer_element_t = buffer_element<B>::type;

template<class T>
constexpr bool is_stream_type_v = std::is_base_of_v<adf::detail::input_stream_base, T> || std::is_base_of_v<adf::detail::output_stream_base, T>;

template<typename Tb, typename Ti>
Tb * add_byte( Tb * ptr, Ti inc ) {
    return byte_incr( ptr, inc );
}
template<typename Tb, typename Ti>
requires( std::is_same_v<std::remove_reference_t<Ti>, dims_2d_t> && !is_stream_type_v<Tb> )
Tb * add_byte( Tb * ptr, Ti inc ) {
    return add_2d_byte( ptr, inc );
}
template<typename Tb, typename Ti>
requires( std::is_same_v<std::remove_reference_t<Ti>, dims_3d_t> && !is_stream_type_v<Tb> )
Tb * add_byte( Tb * ptr, Ti inc ) {
    return add_3d_byte( ptr, inc );
}
template<typename Tb, typename Ti>
requires( is_stream_type_v<Tb> )
Tb * add_byte( Tb * ptr, Ti inc ) {
    return ptr;
    //return byte_incr( ptr, 0 );
}

template<typename Tb, typename Ti>
Tb * add_elem( Tb * ptr, Ti inc ) {
    return ptr + inc;
}
template<typename Tb, typename Ti>
requires( std::is_same_v<std::remove_reference_t<Ti>, dims_2d_t> && !is_stream_type_v<Tb> )
Tb * add_elem( Tb * ptr, Ti inc ) {
    return add_2d_ptr( ptr, inc );
}
template<typename Tb, typename Ti>
requires( std::is_same_v<std::remove_reference_t<Ti>, dims_3d_t> && !is_stream_type_v<Tb> )
Tb * add_elem( Tb * ptr, Ti inc ) {
    return add_3d_ptr( ptr, inc );
}
template<typename Tb, typename Ti>
requires( is_stream_type_v<Tb> )
Tb * add_elem( Tb * ptr, Ti inc ) {
    return ptr;
    //return byte_incr( ptr, 0 );
}

template<unsigned N, typename Tb, typename Tr=Tb>
aie::vector<Tr, N> read_v( Tb * ptr ) {
    return aie::load_v<N>( ptr );
}
template<unsigned N, typename Tb, typename Tr=Tb>
aie::vector<Tr, N> read_v( input_stream<Tb> * ptr ) {
    return readincr_v<N>( ptr );
}
template<unsigned N, typename Tb, typename Tr=Tb>
void write_v( Tb * ptr, aie::vector<Tr, N> val, int tlast=0 ) {
    aie::store_v( ptr, val );
}
template<unsigned N, typename Tb, typename Tr=Tb>
void write_v( output_stream<Tb> * ptr, aie::vector<Tr, N> val, int tlast=0) {
    writeincr( ptr, val.to_native( ), tlast );
}

#endif
