#ifndef __CONV_INT8x8_WRAPPER_CC__
#define __CONV_INT8x8_WRAPPER_CC__
#include "biased_conv_int8x8_impl.hpp"

void run_conv_noqdq_a8w8(KernelArgs& args)
{
    BiasedConvInt8x8IdxParams* conv_layer_params = static_cast<BiasedConvInt8x8IdxParams*>(args.params_data);
    set_sat();
    set_rnd(rnd_conv_even);
    BufferPort* ifm = (conv_layer_params->mode == 0) ? args.s2mm_ch0_port : args.s2mm_ch1_port;
    BufferPort* wgt = (conv_layer_params->mode == 0) ? args.s2mm_ch1_port : args.s2mm_ch0_port;
    BufferPort* ofm = args.mm2s_ch0_port;
    logical_BufferPort bias(
        reinterpret_cast<void*>(byte_incr(wgt->get_curr_addr(), conv_layer_params->wgt_size)),
        reinterpret_cast<void*>(byte_incr(wgt->get_prev_addr(), conv_layer_params->wgt_size))
    );

    if (conv_layer_params->hardened_loop == 1) {
        biased_conv_int8x8<false, false, true, 1, 64>(*ifm, *wgt, bias, *ofm, *conv_layer_params);
    } else if (conv_layer_params->hardened_loop == 2) {
        biased_conv_int8x8<false, false, true, 2, 64>(*ifm, *wgt, bias, *ofm, *conv_layer_params);
    } else if (conv_layer_params->hardened_loop == 3) {
        biased_conv_int8x8<false, false, true, 3, 64>(*ifm, *wgt, bias, *ofm, *conv_layer_params);
    } else {
        biased_conv_int8x8<false, false, true, -1, 64>(*ifm, *wgt, bias, *ofm, *conv_layer_params);
    }
}
#endif