#ifndef __CONV_QDQ_A16W8_WRAPPER_CC__
#define __CONV_QDQ_A16W8_WRAPPER_CC__
#include "activated_conv_qdq_int16x8_impl.hpp"


void run_conv_qdq_a16w8(KernelArgs& args)
{
    ActivatedConvInt16x8Params* conv_layer_params = static_cast<ActivatedConvInt16x8Params*>(args.params_data);
    BufferPort* ifm = (conv_layer_params->mode == 0) ? args.s2mm_ch0_port : args.s2mm_ch1_port;
    BufferPort* wgt = (conv_layer_params->mode == 0) ? args.s2mm_ch1_port : args.s2mm_ch0_port;
    BufferPort* ofm = args.mm2s_ch0_port;

    TypedBufferPort<int16_t> ifm_port(*ifm);
    TypedBufferPort<int8_t> wgt_port(*wgt);
    TypedBufferPort<int16_t> ofm_port(*ofm);

    int8* spill_buf = reinterpret_cast<int8*>(conv_to_local_ptr(conv_layer_params->spill_buf));
    int8* cf_cache = reinterpret_cast<int8*>(conv_to_local_ptr(conv_layer_params->cf_cache));

    logical_BufferPort bias(
        reinterpret_cast<void*>(byte_incr(wgt->get_curr_addr(), conv_layer_params->wgt_size)),
        reinterpret_cast<void*>(byte_incr(wgt->get_prev_addr(), conv_layer_params->wgt_size))
    );

    Typedlogical_BufferPort<float> bias_port(bias);
    activated_conv_qdq_int16x8<true, 2, -1>(ifm_port, wgt_port, bias_port, ofm_port, spill_buf, cf_cache, *conv_layer_params);
}
#endif // __CONV_QDQ_A16W8_WRAPPER_CC__