/*  (c) Copyright 2019 - 2025 Xilinx, Inc. All rights reserved.
    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.
    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.
    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.
    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __KERNEL_DQ_IMPL_HPP__
#define __KERNEL_DQ_IMPL_HPP__

#include "dq.hpp"

/* DQ */
template<typename To, unsigned vector_coeff=0,bool is_int16=true, unsigned N=32>
NO_INLINE void dq
(
    int8_t * input,
    float * coeff,
    To * restrict output,
    const KernelDqParam &params,
    bool enable
) {
    if (!enable){ return; }
    static_assert( vector_coeff == 0, "Vector coefficients not yet supported" );

    /* Pointers */
    int8_t * pIn = ( int8_t __aie_dm_resource_a * ) input;
    float  * pC  = ( float  __aie_dm_resource_b * ) coeff;
    To     * pO  = ( To     __aie_dm_resource_b * ) output;
    
    int8_t sign_A = params.sign_A;

    /* Load coeffs */
    aie::vector<float, N> scale = read_v<N>( pC+64 );
    aie::accum<accfloat, N> zp = aie::mul( aie::neg( read_v<N>( pC )), scale );
    
        for ( unsigned j = 0; j < params.inner_g; j++ )
        chess_prepare_for_pipelining
        chess_loop_range( 12, )
    {
        /* Read input as int8 or int16 and convert it to int32 */
        aie::vector<int32, N> inp_vec = ( v32int32 ) sups( aie::select( read_v<N>( pIn ).unpack_sign(sign_A ), read_v<N>(( int16 * ) pIn ), aie::mask<N>( is_int16 )), 0 , sign_A);
        aie::vector<To, N> DQvec = aie::mac( zp, inp_vec, scale ).template to_vector<To>( );

        write_v( pO, DQvec );
        pIn += N << is_int16;
        pO  += N;
    }
}


NO_INLINE void dq_float16_v32(
    int8_t * input,
    float * coeff,
    QDQFloatType * restrict output,
    const KernelDqParam &params,
    bool enable = true,
    bool is_int16 = true
){
    if (is_int16){
        dq<QDQFloatType, 0, true, 32>(input, coeff, output, params, enable);
    } else {
        dq<QDQFloatType, 0, false, 32>(input, coeff, output, params, enable);
    }
}

// backwards compatibility
NO_INLINE void dq_bfloat16_v32(
    int8_t * input,
    float * coeff,
    bfloat16 * restrict output,
    const KernelDqParam &params,
    bool enable = true,
    bool is_int16 = true
){
    if (is_int16){
        dq<bfloat16, 0, true, 32>(input, coeff, output, params, enable);
    } else {
        dq<bfloat16, 0, false, 32>(input, coeff, output, params, enable);
    }
}

#endif // __DQ_TEMPLATE__