#ifndef __DQ_WRAPPER_CC__
#define __DQ_WRAPPER_CC__

#include "dq/dq.hpp"
#include "dq/dq_impl.hpp"
#include "uniop/uniop_qdq.hpp"

#define DEBUG_DEQUANT 0

void run_dequant(KernelArgs& args) 
{
    dequant_layer_param* layer_params = (dequant_layer_param*)args.params_data;

    int8_t* matA      = reinterpret_cast<int8_t*>(layer_params->input_addr); 
    int8_t* output    = reinterpret_cast<int8_t*>(layer_params->output_addr); 
    int8_t* matQdq    = reinterpret_cast<int8_t*>(layer_params->qdq_param_addr);

#if DEBUG_DEQUANT
    if((get_coreid() & 0xF)==2 && (get_coreid() >> 16)==0)
    {
        chess_report(layer_params->input_addr);
        chess_report(layer_params->output_addr);
        chess_report(layer_params->spill_a_addr);
        chess_report(layer_params->spill_b_addr);
        chess_report(layer_params->qdq_param_addr);
        chess_report(layer_params->qdq_buffer_addr);
        chess_report(outer_g);
    }
#endif

    uniop_qdq_param* qdqprm = reinterpret_cast<uniop_qdq_param*>(layer_params->qdq_param_addr);    
    bool dequant_en  = (qdqprm->dq_enable == 1);
    
    KernelDqParam dq_krn_param;
    dq_krn_param.inner_g = layer_params->num_iters;
    dq_krn_param.sign_A = layer_params->sign_A;
    v32accfloat *dq_buf = (v32accfloat*)(qdqprm->dq_buf);

#if DEBUG_DEQUANT
    int rowIdx_reg = (get_coreid() & 0xF);
    int colIdx_reg = (get_coreid() >> 16);
    if(colIdx_reg == 0 && rowIdx_reg == 2)
    {
        chess_report(dq_buf[0]);
        chess_report(dq_buf[2]);
        chess_report(dequant_en);
    }
#endif

    if(qdqprm->dq_float_type == uniop_qdq_param::FloatType::FLOAT32)
    {
        dq<float, 0, true, 32>((int8_t*) matA, (float*) dq_buf, (float*) output, dq_krn_param, dequant_en);
    }
    else
    {
        dq_float16_v32((int8_t*) matA, (float*) dq_buf, (QDQFloatType*) output, dq_krn_param, dequant_en);
    }
}
#endif