#ifndef __DWC_QDQ_A16W8_WRAPPER_CC__
#define __DWC_QDQ_A16W8_WRAPPER_CC__
#include "activated_dwc_qdq_int16x8_s1_impl.hpp"
#include "activated_dwc_qdq_int16x8_s2_impl.hpp"

void run_dwc_qdq_a16w8(KernelArgs& args)
{
    ActivatedDwcQdqInt16x8Params* dwc_layer_params = static_cast<ActivatedDwcQdqInt16x8Params*>(args.params_data);
    int* ifm = (dwc_layer_params->mode == 0) ? (int*)args.s2mm_ch0_port->data() : (int*)args.s2mm_ch1_port->data();
    int* wgt = (dwc_layer_params->mode == 0) ? (int*)args.s2mm_ch1_port->data() : (int*)args.s2mm_ch0_port->data();
    int* ofm = (int*)args.mm2s_ch0_port->data();
    float* coeff_buff = reinterpret_cast<float*>( byte_incr(wgt, dwc_layer_params->wgt_size) );
    dwcint16x8_RT_params* rt_params = reinterpret_cast<dwcint16x8_RT_params*>(byte_incr(wgt, dwc_layer_params->wgt_size + dwc_layer_params->coeff_size));
    if (dwc_layer_params->stride == 1) {
        activated_dwc_qdq_int16x8_s1<1>(ifm, wgt, coeff_buff, ofm, (int8)rt_params->zp_w, *dwc_layer_params, rt_params->shift);
    } else if (dwc_layer_params->stride == 2) {
        activated_dwc_qdq_int16x8_s2<1>(ifm, wgt, coeff_buff, ofm, (int8)rt_params->zp_w, *dwc_layer_params, rt_params->shift);
    }
}

#endif // __DWC_QDQ_A16W8_WRAPPER_CC__