/*  (c) Copyright 2019 - 2025 Xilinx, Inc. All rights reserved.

    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.

    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.

    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.

    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __GLOBALAVGPOOL_INT8X8_TEMPLATE_H__
#define __GLOBALAVGPOOL_INT8X8_TEMPLATE_H__

#include "common.hh"
#include "aie_api/aie.hpp"
// NOTE: What kind of memory overhead does this introduce?
// Can we remove the cmath?
#include <cmath>

using namespace aie;

template<typename dtype, unsigned granC=64>
ALWAYS_INLINE void globalavgpool_int8x8_template
(
        int * input,
        int * restrict output,
        const MLLayerParams &params,
        const MLKernelControl ctrl
) {
    dtype * pA = ( dtype __aie_dm_resource_a * ) input;
    dtype * pO = ( dtype __aie_dm_resource_b * ) output;

    v32acc32* tdm1 = reinterpret_cast<v32acc32*>(static_cast<uint32_t>(params.offset_interm));
    v32acc32* tdm2 = ( v32acc32* ) tdm1 + params.kernel.outer_g;

    constexpr unsigned il_unroll_factor = 2;
    unsigned last_it  = params.kernel.inner_g % il_unroll_factor;
    unsigned il_bound = std::floor( params.kernel.inner_g / il_unroll_factor );

    uint8_t div_factor = params.kernel.param_value;
    uint8_t last_it_en = div_factor * last_it;

    /* Addressing */
    dims_3d_t dimsA = dims_3d_from_steps( params.kernel.X_g, granC, params.kernel.Y_g, params.kernel.step_Yi, 0 );
    int reset = params.kernel.X_g > 1 ? granC : params.kernel.step_Yi;
    int incr_last_it = last_it ? ( params.kernel.step_Ci ) : ( params.kernel.step_Ci - reset );
    int step_O = params.tdm_cnt == params.iter_cnt ? granC : 0;


    /* Channels -> C_g */
    for ( unsigned j = 0; j < params.kernel.outer_g; j++ )
        chess_prepare_for_pipelining
        chess_loop_range( 2, )
    {
        /* Reset counters */
        dimsA.count1 = 0;
        dimsA.count2 = 0;

        accum<acc32, 32> acc0, acc1;
        accum<acc32, 32> acc2, acc3;

        acc0 = tdm1[j];
        acc1 = tdm2[j];

        int zero_acc = params.tdm_cnt == 0 ? 1 : 0;
        int init_acc = 1;

        /* Height and width ->  H * W */
        for ( unsigned i = 0; i < il_bound; i++ )
            chess_prepare_for_pipelining
            chess_loop_range( 4, )
        {
            /* Load activations - C64 */
            vector<dtype, granC> Xbuff0 = load_v<granC>( pA );
            pA = add_3d_byte( pA, dimsA );
            vector<dtype, granC> Xbuff1 = load_v<granC>( pA );

            #ifdef __AIE_MODEL_VERSION__ >= 4300
            acc0 = aie::mac( op_zero( acc0, zero_acc ), Xbuff0.template extract<32>( 0 ), div_factor );
            acc1 = aie::mac( op_zero( acc1, zero_acc ), Xbuff0.template extract<32>( 1 ), div_factor );
            acc2 = aie::mac( op_zero( acc2, init_acc ), Xbuff1.template extract<32>( 0 ), div_factor );
            acc3 = aie::mac( op_zero( acc3, init_acc ), Xbuff1.template extract<32>( 1 ), div_factor );
            #else
            acc0 = mac_elem_32_conf( Xbuff0, ctrl.sign_A,  div_factor, false, acc0, zero_acc, 0, 0 );
            acc1 = mac_elem_32_conf( shuffle( Xbuff0, T256_2x2_hi ), ctrl.sign_A, div_factor, false, acc1, zero_acc, 0, 0);
            acc2 = mac_elem_32_conf( Xbuff1, ctrl.sign_A, div_factor, false, acc2, init_acc, 0, 0 );
            acc3 = mac_elem_32_conf( shuffle( Xbuff1, T256_2x2_hi ), ctrl.sign_A, div_factor, false, acc3, init_acc, 0, 0);
            #endif

            /* Increment pointer */
            pA = add_3d_byte( pA, dimsA );
            zero_acc = 0;
            init_acc = 0;
        }

        /* Optional last inner loop iteration - Depending on problem size */
        vector<dtype, granC> Xbuff = load_v<granC>( pA );
        #ifdef __AIE_MODEL_VERSION__ >= 4300
        acc0 = aie::mac( op_zero( acc0, zero_acc ), Xbuff.template extract<32>( 0 ), last_it_en );
        acc1 = aie::mac( op_zero( acc1, zero_acc ), Xbuff.template extract<32>( 1 ), last_it_en );
        #else
        acc0 = mac_elem_32_conf( Xbuff, ctrl.sign_A, last_it_en, false, acc0, zero_acc, 0, 0 );
        acc1 = mac_elem_32_conf( shuffle( Xbuff, T256_2x2_hi ), ctrl.sign_A, last_it_en, false, acc1, zero_acc, 0, 0);
        #endif
        pA = add_3d_byte( pA, dimsA );
        pA = byte_incr( pA, incr_last_it );

        /* Add accumulators */
        acc0 = acc0 + acc2;
        acc1 = acc1 + acc3;

        tdm1[j] = acc0;
        tdm2[j] = acc1;

        /* Write output */
        vector<dtype, 32> out0 = acc0.template to_vector_sign<dtype>( ctrl.sign_O, params.kernel.shift_res );
        vector<dtype, 32> out1 = acc1.template to_vector_sign<dtype>( ctrl.sign_O, params.kernel.shift_res );
        
        aie::store_v( pO, out0 );
        aie::store_v( pO + 32, out1 );

        pO += step_O;
    }
}


#endif // __GENERIC_GAP_INT8X8_TEMPLATE_H__