#ifndef __GLOBALAVGPOOL_INT8X8_WRAPPER_H__
#define __GLOBALAVGPOOL_INT8X8_WRAPPER_H__
#include "globalavgpool_int8x8_template.h"

void run_globalavgpool_int8x8(KernelArgs& args)
{
    MLLayerParams* gap_layer_params = static_cast<MLLayerParams*>(args.params_data);
    //NOTE: where do we need these?
    set_sat();
    set_rnd(rnd_conv_even);
    int8_t* ifm = static_cast<int8_t*>(args.s2mm_ch0_port->data());
    int8_t* ofm = static_cast<int8_t*>(args.mm2s_ch0_port->data());
    
    // Call the template function instead of the direct function
    globalavgpool_int8x8_template<int8_t, 64>(
        (int *)ifm, (int *)ofm, *gap_layer_params, gap_layer_params->kernel.ctrl
    );
}
#endif