def gpn_layer_params(
    CoreInputAddr: int,
    CoreOutputAddr: int,
    CoreScratchAddr: int,
    CoreWgtAddr: int,
    QdqParamAddr: int,
    dqBufferAddr: int,
    qBufferAddr: int,
    msubv: int,
    nsubv: int,
    group_size: int,
    num_groups: int,
    op_type: int,
    is_last_iter: int,
    mparam: int,
    enable_global_reduce: int,
    ifmbytes: int,
    ofmbytes: int
) -> bytes:
    """Generate the layer parameters for the SOFTMAX operation."""
    CoreInputAddr += 0xE0000
    CoreOutputAddr += 0xE0000
    CoreScratchAddr += 0xE0000
    CoreWgtAddr += 0xE0000
    QdqParamAddr += 0xE0000
    dqBufferAddr += 0xE0000
    qBufferAddr += 0xE0000
    
    bytes = (
        CoreInputAddr.to_bytes(length=4, byteorder="little", signed=False)
        + CoreOutputAddr.to_bytes(length=4, byteorder="little", signed=False)
        + CoreScratchAddr.to_bytes(length=4, byteorder="little", signed=False)
        + CoreWgtAddr.to_bytes(length=4, byteorder="little", signed=False)
        + QdqParamAddr.to_bytes(length=4, byteorder="little", signed=False)
        + dqBufferAddr.to_bytes(length=4, byteorder="little", signed=False)
        + qBufferAddr.to_bytes(length=4, byteorder="little", signed=False)
        + msubv.to_bytes(length=4, byteorder="little", signed=False)
        + nsubv.to_bytes(length=4, byteorder="little", signed=False)
        + group_size.to_bytes(length=4, byteorder="little", signed=False)
        + num_groups.to_bytes(length=4, byteorder="little", signed=False)
        + op_type.to_bytes(length=4, byteorder="little", signed=False)
        + is_last_iter.to_bytes(length=4, byteorder="little", signed=False)
        + mparam.to_bytes(length=4, byteorder="little", signed=False)
        + enable_global_reduce.to_bytes(length=4, byteorder="little", signed=False)
        + ifmbytes.to_bytes(length=4, byteorder="little", signed=False)
        + ofmbytes.to_bytes(length=4, byteorder="little", signed=False)
    )

    return bytes