#ifndef __KERNEL_L2NORM_FP16X16_HPP__
#define __KERNEL_L2NORM_FP16X16_HPP__

#include "stdint.h"
#include "dtype_check.hpp"
#include "common.hh"
//#include "kernel_helpers.h"
//#include "ml_params.h"
#include "access_helpers.hpp"

struct KernelL2Norm_fp16x16_Param {
    uint16_t order_64;
    uint16_t inner_g;
    uint16_t X_g;
    uint16_t outer_g;
    dims_2d_param dimsI_ol;
    dims_2d_param dimsO_ol;
    dims_2d_param dimsI_il;
    dims_2d_param dimsO_il;
};

template<typename Ti, typename To>
requires(( std::is_same_v<Ti, float16> || std::is_same_v<Ti, bfloat16> ) && ( std::is_same_v<To, float16> || std::is_same_v<To, bfloat16> ))
void l2norm_fp16x16
(
        Ti * input,
        Ti * weights,
        To * restrict output,
        const KernelL2Norm_fp16x16_Param &params
);

struct l2norm_layer_param
{
    uint32_t input_addr;
    uint32_t weight_addr;
    uint32_t output_addr;
    uint32_t qdq_param_addr;
    uint32_t dq_buffer_addr;
    uint32_t q_buffer_addr;
    uint32_t true_num_cols;
    uint32_t Msubv;
    uint32_t Nsubv;
    uint32_t num_elem_subv;
    uint32_t sign_A;
    uint32_t sign_O;
    KernelL2Norm_fp16x16_Param krn_param;
};
#endif