/*  (c) Copyright 2019 - 2022 Xilinx, Inc. All rights reserved.
    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.
    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.
    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.
    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __KERNEL_L2NORM_FP16X16_IMPL_HPP__
#define __KERNEL_L2NORM_FP16X16_IMPL_HPP__

#include <stdio.h>
#include <type_traits>
#include "l2norm_fp16x16.hpp"
#include "common.hh"

template<typename Ti, typename To>
requires(( std::is_same_v<Ti, float16> || std::is_same_v<Ti, bfloat16> ) && ( std::is_same_v<To, float16> || std::is_same_v<To, bfloat16> ))
void l2norm_fp16x16
(
        Ti * input,
        Ti * weights,
        To * restrict output,
        const KernelL2Norm_fp16x16_Param &params
) { 
    constexpr unsigned granY = 1;
    constexpr unsigned granX = 4;
    constexpr unsigned granC = 32;
    const unsigned granC_d = params.order_64 == 0 ? 32 : 64;
    constexpr unsigned granXC = granX * granC;

    // Access the type through the namespace  
    using VTYPE = typename VType::get_v_type<Ti>::type; 

    int inner_g = params.inner_g;
    int outer_g = params.outer_g;
    int rnd = get_rnd( );
    
    Ti * pIn  = input;
    Ti * pIn2;
    To * pOut = output;

    auto dimsI_ol = params.dimsI_ol.instantiate();
    auto dimsO_ol = params.dimsO_ol.instantiate();
    auto dimsI_il = params.dimsI_il.instantiate();
    auto dimsO_il = params.dimsO_il.instantiate();
    
    event0( );
    v32float ones = broadcast_to_v32float(1.0f);
    v32accfloat zeros = broadcast_to_v32accfloat(0.0f);

    for ( int j=0; j<outer_g; j+=inner_g )
        chess_loop_range( 1, )
    {
        v32accfloat acc[granX];
        VTYPE x[granX];
        float acc_s[granX] = {0.f};
        int zero_init = 1;

        pIn2 = pIn;

        for ( int i=0; i<inner_g; i++ )
            chess_prepare_for_pipelining
            chess_loop_range( 8, )
        {
            #pragma unroll
            for ( int nx=0; nx < granX; nx++ )
            {
                pIn       = chess_copy( pIn );
                x[nx]     = read_v<granC>(pIn + granC_d * nx);
                acc[nx]   = mac_elem_32_conf( x[nx], x[nx], acc[nx], zero_init, 0, 0 ); /* x² */                   
            }
            pIn = add_2d_byte( pIn, dimsI_il);
            zero_init = 0;
        }

        #pragma unroll
        for ( int nx=0; nx < granX; nx++ )
        {
            /* l2norm = sqrt(Σ(x²)) */
            acc_s[nx] = add_reduce(v32float(acc[nx]));
            // acc_s[nx] = min( sqrt( acc_s[nx] ), 1/1e-6);
            acc_s[nx] = min_reduce( broadcast_to_v32float(invsqrt( acc_s[nx] )), 1.f/1e-12);
        }

        /* Alpha Beta only on Ci */
        Ti * pW = weights;

        for ( int i=0; i<inner_g; i++ )
            chess_prepare_for_pipelining
            chess_allocate(Y:8)            
            chess_loop_range( 8, )
        {
            v32accfloat tmp0[granX];

            /* Load Alpha and Beta */
            v64accfloat W = to_v64accfloat( read_v<64>(pW) );

            pW = byte_incr(pW, 2 * granC * 2);
            
            #pragma unroll
            for ( int nx=0; nx < granX; nx++ )
            {
                pOut = chess_copy( pOut );
                pIn2 = chess_copy( pIn2 );

                /* x * norm_multiplicative( x ) */
                //tmp0[nx] = mul_elem_32( v32float(extract_v32accfloat( W, 1 ) ), acc_s[nx]);
                tmp0[nx] = mul_elem_32( ones, acc_s[nx]);
                x[nx]    = read_v<granC>( pIn2 + granC_d * nx );
                //tmp0[nx] = mac_elem_32( v32float( to_v32accfloat(x[nx])), v32float(tmp0[nx] ), extract_v32accfloat( W, 0 ));
                tmp0[nx] = mac_elem_32( v32float( to_v32accfloat(x[nx])), v32float(tmp0[nx] ), zeros);

                store<VTYPE,v32accfloat>( (VTYPE*) (pOut + granC_d * nx), tmp0[nx]);
            }

            pIn2 = add_2d_byte( pIn2, dimsI_il);
            pOut = add_2d_byte( pOut, dimsO_il);
        }

        pIn  = add_2d_byte( pIn, dimsI_ol );
        pOut = add_2d_byte( pOut, dimsO_ol );
    }

    event1( );

}


#endif