/*  (c) Copyright 2019 - 2022 Xilinx, Inc. All rights reserved.
    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.
    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.
    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.
    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

    #ifndef __KERNEL_LAYER_NORM_FP16X16_IMPL_HPP__
    #define __KERNEL_LAYER_NORM_FP16X16_IMPL_HPP__
    
    #include <stdio.h>
    #include <type_traits>
    #include "layer_norm_fp16x16.hpp"
    #include "common.hh"

    template<typename Ti, typename To>
    requires(( std::is_same_v<Ti, float16> || std::is_same_v<Ti, bfloat16> ) && ( std::is_same_v<To, float16> || std::is_same_v<To, bfloat16> ))
    void layer_norm_fp16x16
    (
            Ti * input,
            Ti * weights,
            To * restrict output,
            const KernelLayerNorm_fp16x16_Param &params
    ) { 
        constexpr unsigned granY = 1;
        constexpr unsigned granX = 2;
        constexpr unsigned granC = 32;
        const unsigned granC_d = params.order_64 == 0 ? 32 : 64;
        const unsigned granXC = granX * granC_d;

        // Access the type through the namespace  
        using VTYPE = typename VType::get_v_type<Ti>::type; 
    
        int inner_g = params.inner_g;
        int outer_g = params.outer_g;
        int rnd = get_rnd( );
    
        Ti * pIn  = input;
        Ti * pIn2;
        To * pOut = output;

        auto dimsI_ol = params.dimsI_ol.instantiate();
        auto dimsO_ol = params.dimsO_ol.instantiate();
        auto dimsI_il = params.dimsI_il.instantiate();
        auto dimsO_il = params.dimsO_il.instantiate();
        
        event0( );

        v32float ones = broadcast_to_v32float(1.0f);
        v32accfloat zeros = broadcast_to_v32accfloat(0.0f);
        for ( int j=0; j<outer_g; j+=inner_g )
            chess_loop_range( 1, )
        {
            int zero_init = 1;
            pIn2 = pIn;
    
            Ti one_s = Ti( 1.0f );
            float one_sfp = ( 1.0f );
            float inv_s = inv(aie::to_float(inner_g * granC));
    
            v32accfloat acc0[granX];
            v32accfloat acc1[granX];
            VTYPE x[granX];
            
            float mu_s[granX];
            float var[granX];
            float inv_std_s[granX];
            float acc_scalar[granX];
            VTYPE inv_std[granX];
    
            v32float mu;
            v32accfloat ex2;
            v32accfloat mux2;
            v32accfloat tmp;
    
            for ( int i=0; i<inner_g; i++ )
                chess_prepare_for_pipelining
                chess_loop_range( 4, )
            {
                #pragma unroll
                for ( int nx=0; nx < granX; nx++ )
                {
                    x[nx]        = read_v<granC>(pIn + granC_d * nx);
                    acc0[nx]     = mac_elem_32_conf( x[nx], one_s, acc0[nx], zero_init, 0, 0 ); /* x  */
                    acc1[nx]     = mac_elem_32_conf( x[nx], x[nx], acc1[nx], zero_init, 0, 0 ); /* x² */
                }  
                pIn = add_2d_byte( pIn, dimsI_il);
                zero_init = 0;
            }
            
            /* chess_separator(); */
            
            float epsilonx = 1e-5, tmpreduce; /* as_float( params.param_value ); */   
            #pragma unroll
            for ( int nx=0; nx < granX; nx++ )
            {
                epsilonx = chess_copy( epsilonx );
    
                /* µ = Σ (x/N) */
                mu_s[nx] = add_reduce( v32float( mul_elem_32( v32float( acc0[nx]), inv_s ) ) );
                mu = broadcast_to_v32float( (mu_s[nx]) );    
    
                /* scale before add reduction to keep dynamic range and avoid fp16 overflow */
                v16accfloat acc16_epsilon = v16accfloat(broadcast_zero_to_v16float());
                v32accfloat acc_epsilon;
                acc_epsilon   = insert(acc_epsilon, 0, acc16_epsilon);
                acc16_epsilon = insert( acc16_epsilon, 0, epsilonx);
                acc_epsilon   = insert(acc_epsilon, 1, acc16_epsilon);
    
                var[nx] = add_reduce( v32float( mac_elem_32( v32float( acc1[nx]), inv_s, acc_epsilon ) ) );
                ex2 = broadcast_to_v32accfloat( var[nx] );
                tmp = msc_elem_32( mu, mu, ex2 );
    
                /* σ = sqrt( (1/N)*Σ(x²) - µ²) */
                var[nx] = extract_elem( tmp, 0);
    
                /* 1 / σ where σ = sqrt( (1/N)*Σ(x²) - µ² + ε) */
                inv_std_s[nx] = invsqrt( var[nx] );
    
                /* µ / σ  */
                acc_scalar[nx] = extract_elem(negmul_elem_32( v32float(mu), broadcast_to_v32float(inv_std_s[nx])), 0);
                inv_std[nx] = broadcast_to_v32( Ti(inv_std_s[nx]) );
            }

            /* Alpha Beta only on Ci */
            Ti * pW = weights;

            /*int rowIdx_reg = (get_coreid() & 0xF);
            int colIdx_reg = (get_coreid() >> 16);
            if(colIdx_reg == 0 && rowIdx_reg == 2)
            {
                v32float16* pW_v32 = (v32float16*)weights;
                for(int i = 0; i < 256 * 2 / 32; i++)
                {
                    chess_report(pW_v32[i]);
                }
            }  
            chess_report(0xFFFF);*/

    
            /* chess_separator(); */
            for ( int i=0; i<inner_g; i++ )
                chess_prepare_for_pipelining
                chess_allocate(Y:4)
                chess_loop_range( 4, )
            {
                v32accfloat tmp0[granX], tmp1[granX];
                VTYPE  in3[granX];
                v32accfloat accW0 = to_v32accfloat( read_v<granC>(pW) );
                v32float       W1 = v32float( to_v32accfloat( read_v<granC>(pW + granC) ) );

                pW = byte_incr(pW, 2 * granC * 2);
                
                #pragma unroll
                for ( int nx=0; nx < granX; nx++ )
                {
                    pOut = chess_copy( pOut );
                    pIn2 = chess_copy( pIn2 );
                    in3[nx] = read_v<granC>( pIn2 + granC_d * nx );

                    tmp0[nx] = mac_elem_32( in3[nx], inv_std[nx], acc_scalar[nx] );
                    tmp1[nx] = mac_elem_32( v32float(tmp0[nx]), W1, accW0 );
                    // tmp1[nx] = mac_elem_32( v32float(tmp0[nx]), ones, zeros );
    
                    if (std::is_same_v<To, float8>) {
                        // store( (pOut + granC * nx), to_v32float8(tmp1[nx]) );
                    } else {
                        store<VTYPE,v32accfloat>( (VTYPE*) (pOut + granC_d * nx), tmp1[nx]);
                    }
                }
                pIn2 = add_2d_byte( pIn2, dimsI_il);
                pOut = add_2d_byte( pOut, dimsO_il);
            }
            
            pIn  = add_2d_byte( pIn, dimsI_ol );
            pOut = add_2d_byte( pOut, dimsO_ol );            
        }
    
        event1( );
    
    }
    
    
    #endif