/*  (c) Copyright 2019 - 2024 Xilinx, Inc. All rights reserved.
    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.
    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.
    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.
    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __LINEAR_APPROX_BF16_HPP__
#define __LINEAR_APPROX_BF16_HPP__


//#include "ml_params.h"
//#include "buffer.hpp"
#include "common.hh"
//#include "kernel_helpers.h"
//#include "ml_params.h"
#include "access_helpers.hpp"

template<typename FloatType = bfloat16>
struct LinearApproxBF16Params {
    float idx_bias;
    uint16_t loop;
    FloatType idx_max;
    FloatType idx_min;
    FloatType idx_mul;
};


template<typename dtype,unsigned loop_range>
void linear_approx_bf16
(
    dtype * ifm,
    float * lut_ab,
    float * lut_cd,
    dtype * restrict ofm,
    int * restrict spill_buf,
    const LinearApproxBF16Params<dtype> &params
);

template<typename dtype = bfloat16>
struct linear_approx_layer_param
{
    uint32_t input_addr;
    uint32_t lut_ab_addr;
    uint32_t lut_cd_addr;
    uint32_t spill_buf_addr;
    uint32_t output_addr;
    uint32_t qdq_param_addr;
    uint32_t dq_buffer_addr;
    uint32_t q_buffer_addr;
    uint32_t sign_A;
    uint32_t sign_O;
    LinearApproxBF16Params<dtype> krn_param;
};

#endif //__LINEAR_APPROX_INT32X16_FP_KERNEL_H__