/*  (c) Copyright 2019 - 2024 Xilinx, Inc. All rights reserved.
    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.
    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.
    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.
    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __LINEAR_APPROX_BF16_IMPL_H__
#define __LINEAR_APPROX_BF16_IMPL_H__

#include "aie_api/aie.hpp"
#include "aie_api/utils.hpp"
#include "linear_approx_bf16.hpp"

#ifdef DEBUG_KERNEL
#include "stdio.h"
#endif


template<typename dtype=bfloat16, unsigned loop_range=8>
void
linear_approx_bf16
(
        dtype * ifm,
        float * lut_ab,
        float * lut_cd,
        dtype * restrict ofm,
        int * restrict spill_buf,
        const LinearApproxBF16Params<dtype> &params
) {
    dtype * pIn16  = ifm;
    dtype * pIn16_1  = ifm;
    dtype * pOut16 = ofm;
    constexpr unsigned igran=32;
    // TODO: this is set in the reference kernel to symmetric_zero, needs to be considered in the model
    // This leads to low bit differences between model and kernel as it is not considered in the model, as symmetric_zero is not implemented in the model symmetric_floor is used
    aie::tile::current().set_saturation(aie::saturation_mode::saturate);
    aie::set_rounding(aie::rounding_mode::symmetric_floor);

    const int fifo_size = 8;
    v32int32 __aie_dm_resource_a * restrict fifo_a = (v32int32 __aie_dm_resource_a * restrict) spill_buf;
    v32int32 __aie_dm_resource_a * restrict pFra   = (v32int32 __aie_dm_resource_a * restrict) fifo_a;
    v32int32 __aie_dm_resource_a * restrict pFwa   = (v32int32 __aie_dm_resource_a * restrict) fifo_a;
    
    const int fifo_words = 1;
    dims_2d_t dFra( fifo_size / fifo_words - 1, 1, 1 - fifo_size );
    dims_2d_t dFwa = dFra;

    dtype idx_min = (dtype) params.idx_min;
    dtype idx_max = (dtype) params.idx_max;
    dtype idx_mul = (dtype) params.idx_mul;
    
    constexpr unsigned used_loop_range = loop_range >1 ? loop_range/2 : 1;
    constexpr unsigned unroll_loop = loop_range >1 ? loop_range/2 : 0;

        
    auto idx_body = [&](auto idx) {
            aie::vector<dtype,igran> inp = aie::load_v<igran>(pIn16); pIn16 += igran;
            inp = aie::max(inp,  aie::broadcast<dtype, 32>(idx_min));
            inp = aie::min(inp,  aie::broadcast<dtype, 32>(idx_max));
            aie::accum<accfloat, 32> index_fl = mac_elem_32( inp, aie::broadcast<dtype, 32>(idx_mul), params.idx_bias);
            //CRVO-12756 no API support for to_v32int32
            aie::vector<int32, 32> index_int = to_v32int32(index_fl,0,true);
            *pFwa = (v32int32) index_int; pFwa = add_2d_ptr( pFwa, dFwa );
            if constexpr(loop_range<=2)
                chess_separator_scheduler_local();
    };

    auto lut_body = [&](auto idx) {
        // #pragma unroll
        // for ( unsigned l = 0; l < 2; l++ ) {
            aie::vector<dtype,32> slope;
            aie::vector<dtype,32> offset;
            v32int16 coeff00, coeff10, slope_offset0;
            v32int16 coeff01, coeff11, slope_offset1;
            pFra = chess_copy( pFra ); 
            aie::vector<int32,32> index_int  = *pFra; pFra = add_2d_ptr( pFra, dFra ); pFra = chess_copy( pFra ); 
            load_lut_2x_int16(( int* ) lut_ab, ( int* ) lut_cd, index_int.extract<16>( 0 ), coeff00, coeff10 );
            load_lut_2x_int16(( int* ) lut_ab, ( int* ) lut_cd, index_int.extract<16>( 1 ), coeff01, coeff11 );

            //separate slopes and offsets
            slope_offset0 = shuffle( coeff00, coeff10, T16_16x4_lo );
            slope_offset1 = shuffle( coeff01, coeff11, T16_16x4_lo );
            
            //bring the two slope halves and offset halves together
            if constexpr(std::is_same_v<dtype, bfloat16>){
                slope = v32bfloat16(shuffle( slope_offset0, slope_offset1, T256_2x2_hi));
                offset = v32bfloat16(shuffle( slope_offset0, slope_offset1, T256_2x2_lo)); 
            } else {
                slope = v32float16(shuffle( slope_offset0, slope_offset1, T256_2x2_hi));
                offset = v32float16(shuffle( slope_offset0, slope_offset1, T256_2x2_lo)); 
            }

            aie::accum<accfloat,32> app( offset );
            app = aie::mac( app, slope, aie::load_v<32>(pIn16_1)); pIn16_1+=igran;
            aie::store_v<aie_dm_resource::a>( pOut16, app.to_vector<dtype>( ));    pOut16 += 32;
        // }
    };
    
    //peeling iterations to fill the memory fifo with indices
    #pragma unroll
    for ( unsigned l = 0; l < unroll_loop; l++ )
        idx_body(0);
    chess_separator_scheduler_local();
    for ( int j=0; j<params.loop-loop_range/2; j++ )
        chess_prepare_for_pipelining
        //Compiler gave the hint to increase this
        chess_modulo_scheduling_budget_ratio(140000)
        chess_loop_range( used_loop_range, )
    {
        idx_body(0);
        lut_body(0);
    }
    chess_separator_scheduler_local();
    #pragma unroll
    for ( unsigned l = 0; l < unroll_loop; l++ )
    lut_body(0);
    }

#endif // __LINEAR_APPROX_BF16_IMPL_H__