/*  (c) Copyright 2019 - 2024 Xilinx, Inc. All rights reserved.

    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.

    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.

    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.

    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __MAXPOOL_INT8X8_TEMPLATE_H__
#define __MAXPOOL_INT8X8_TEMPLATE_H__

#include "aie_api/aie.hpp"
#include "common.hh"

using namespace aie;


ALWAYS_INLINE void maxpool_int8x8_template
(
        int * input,
        int * restrict output,
        const MLKernelParams &params,
        const MLKernelControl ctrl
) {

    constexpr int granC = 64;
    bool unroll = ( params.Kx_g == 2 && params.Ky_g == 2 ) ? true : false;

    int8 * pA = ( int8 __aie_dm_resource_a * ) input;
    int8 * pO = ( int8 __aie_dm_resource_b * ) output;

    int ol_bound = params.outer_g;
    int il_bound = params.inner_g-1;

    /* Addressing */
    int reset = -( params.Ky_g * params.step_Ky );
    dims_3d_t dimsA = dims_3d_from_steps( reset, params.X_g, ( params.S_g*granC ), params.Co_g, params.step_Ci, params.step_Yi );
    dims_2d_t dimsK = dims_2d_from_steps( params.Kx_g, granC, params.step_Ky );
    
    vector<int8, granC> Xbuff0, Xbuff1, Obuff;

    auto il_unroll = [&]( ) __attribute__(( always_inline )) {
        Xbuff0 = load_v<granC>( pA );
        pA = add_2d_byte( pA, dimsK );
        
        Obuff = max( Obuff, Xbuff0, ctrl.sign_A );
        
        Xbuff0 = load_v<granC>( pA );
        pA = add_2d_byte( pA, dimsK );
        Xbuff1 = load_v<granC>( pA );
        pA = add_2d_byte( pA, dimsK );

        Obuff = max( Obuff, Xbuff0, ctrl.sign_A );
        Obuff = max( Obuff, Xbuff1, ctrl.sign_A );
    };

    auto il_pipelined = [&]( unsigned il_bound ) __attribute__(( always_inline )) {
        for ( unsigned i = 0; i < il_bound; i++ )
            chess_prepare_for_pipelining
            chess_loop_range( 6, )
        {
            Xbuff0 = load_v<granC>( pA );

            Obuff = max( Obuff, Xbuff0, ctrl.sign_A );

            pA = add_2d_byte( pA, dimsK );

        }
    };


    event0( );

    // Note: Evaluate at compile time to reduce PM
    if ( unroll ) {
        for ( unsigned j = 0; j < ol_bound; j++ )
            chess_prepare_for_pipelining
            chess_loop_range( 2, )
        {
            /* Load data */
            Obuff = load_v<granC>( pA );

            pA = add_2d_byte( pA, dimsK );

            il_unroll( );

            /* Write output */
            store_v( pO, Obuff );

            /* Increment pointers */
            pA = add_3d_byte( pA, dimsA );
            pO += granC;
        }
    } else {
        for ( unsigned j = 0; j < ol_bound; j++ )
            chess_prepare_for_pipelining
            chess_loop_range( 2, )
        {
            /* Load data */
            Obuff = load_v<granC>( pA );

            pA = add_2d_byte( pA, dimsK );

            il_pipelined( il_bound );

            /* Write output */
            store_v( pO, Obuff );

            /* Increment pointers */
            pA = add_3d_byte( pA, dimsA );
            pO += granC;
        }

    }

    event1( );
}



#endif // __MAXPOOL_INT8X8_TEMPLATE_H__
