#ifndef __MAXPOOL_INT8x8_WRAPPER_CC__
#define __MAXPOOL_INT8x8_WRAPPER_CC__
#include "maxpool_int8x8_template.h"

void run_maxpool_int8x8(KernelArgs& args)
{
    set_sat();
    set_rnd(rnd_conv_even);
    maxpool_layer_params* params = static_cast<maxpool_layer_params*>(args.params_data);
    int* ifm = (params->mode == 0) ? (int*)args.s2mm_ch0_port->data() : (int*)args.s2mm_ch1_port->data();
    maxpool_noqdq_params* qdq_params = (params->mode == 0) ? (maxpool_noqdq_params*)args.s2mm_ch1_port->data() : (maxpool_noqdq_params*)args.s2mm_ch0_port->data();
    params->kernel_params.ctrl.sign_A = qdq_params->sign; 
    int* ofm = (int*)args.mm2s_ch0_port->data();

    maxpool_int8x8_template(ifm, ofm, params->kernel_params, params->kernel_params.ctrl);

}
#endif
