/*  (c) Copyright 2019 - 2025 Xilinx, Inc. All rights reserved.
    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.
    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.
    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.
    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __KERNEL_Q_IMPL_HPP__
#define __KERNEL_Q_IMPL_HPP__

#include "q.hpp"
#include "common.hh"
//#include "ml_params.h"
//#include "kernel_helpers.h"
#include "access_helpers.hpp"


template<typename Ti, typename To, unsigned vector_coeff=0, unsigned N=32>
NO_INLINE void q
(
    Ti * input,
    float * coeff,
    To * restrict output,
    const KernelQParam &params,
    bool enable
) {
    if (!enable){ return; }
    static_assert( vector_coeff == 0, "Vector coefficients not yet supported" );

    // /* Pointers */
    Ti    * pIn = ( Ti    __aie_dm_resource_a * ) input;
    float * pC  = ( float __aie_dm_resource_b * ) coeff;
    To    * pO  = ( To    __aie_dm_resource_b * ) output;

    /* Load coeffs */
    aie::vector<float, N> scale = read_v<N>( pC+64 );
    aie::accum<accfloat, N> zp;
    zp.from_vector_sign( read_v<N>( pC ), params.sign_O );

    for ( unsigned j = 0; j < params.inner_g; j++ )
        chess_prepare_for_pipelining
        chess_loop_range( 10, )
    {
        aie::vector<float, N> inp_vec = locate_in_register<0>( aie::accum<accfloat,32>( read_v<N>( pIn )).to_vector<float>( ));
        aie::vector<float, N> acc = aie::mac( zp, inp_vec, scale ).template to_vector<float>( );

        aie::vector<To, N> Qvec = convert<typename aie::vector<To,32>::native_type>( acc.to_native( ), 0, params.sign_O );

        write_v( pO, Qvec );
        pIn += N;
        pO  += N;
    } 
}

// Non-templated helper to keep wrappers from depending on the q template signature.
NO_INLINE void q_float16_to_int16_v32(
    QDQFloatType * input,
    float * coeff,
    int16 * restrict output,
    const KernelQParam &params,
    bool enable = true,
    bool is_int16 = true
){
    if (is_int16){
        q<QDQFloatType, int16, 0, 32>(input, coeff, (int16_t*) output, params, enable);
    } else {
        q<QDQFloatType, int8_t, 0, 32>(input, coeff, (int8_t*) output, params, enable);
    }
}

// backwards compatibility
NO_INLINE void q_bfloat16_to_int16_v32(
    bfloat16 * input,
    float * coeff,
    int16 * restrict output,
    const KernelQParam &params,
    bool enable = true,
    bool is_int16 = true
){
    if (is_int16){
        q<bfloat16, int16, 0, 32>(input, coeff, (int16_t*) output, params, enable);
    } else {
        q<bfloat16, int8_t, 0, 32>(input, coeff, (int8_t*) output, params, enable);
    }
}

#endif // __Q_TEMPLATE__
