def quant_layer_params(
    CoreInputAddr: int,
    CoreOutputAddr: int,
    QdqParamAddr: int,
    num_iters: int,
    sign_O: int
) -> bytes:

    CoreInputAddr += 0xE0000
    CoreOutputAddr += 0xE0000
    QdqParamAddr += 0xE0000

    bytes = (
        CoreInputAddr.to_bytes(length=4, byteorder="little", signed=False)
        + CoreOutputAddr.to_bytes(length=4, byteorder="little", signed=False)
        + QdqParamAddr.to_bytes(length=4, byteorder="little", signed=False)
        + num_iters.to_bytes(length=4, byteorder="little", signed=False)
        + sign_O.to_bytes(length=4, byteorder="little", signed=False)
    )
    # log("Number of bytes dequant layer params:", len(bytes))
    return bytes