#ifndef __Q_WRAPPER_CC__
#define __Q_WRAPPER_CC__

#include "q/q.hpp"
#include "q/q_impl.hpp"
#include "uniop/uniop_qdq.hpp"

#define DEBUG_DEQUANT 0

void run_quant(KernelArgs& args) 
{
    quant_layer_param* layer_params = (quant_layer_param*)args.params_data;

    int8_t* matA      = reinterpret_cast<int8_t*>(layer_params->input_addr); 
    int8_t* output    = reinterpret_cast<int8_t*>(layer_params->output_addr); 
    int8_t* matQdq    = reinterpret_cast<int8_t*>(layer_params->qdq_param_addr);

#if DEBUG_DEQUANT
    if((get_coreid() & 0xF)==2 && (get_coreid() >> 16)==0)
    {
        chess_report(layer_params->input_addr);
        chess_report(layer_params->output_addr);
        chess_report(layer_params->spill_a_addr);
        chess_report(layer_params->spill_b_addr);
        chess_report(layer_params->qdq_param_addr);
        chess_report(layer_params->qdq_buffer_addr);
        chess_report(outer_g);
    }
#endif

    uniop_qdq_param* qdqprm = reinterpret_cast<uniop_qdq_param*>(layer_params->qdq_param_addr);    
    bool quant_en  = (qdqprm->q_enable == 1);
    
    KernelQParam q_krn_param;
    q_krn_param.inner_g = layer_params->num_iters;
    q_krn_param.sign_O = layer_params->sign_O;
    v32accfloat *q_buf = (v32accfloat*)(qdqprm->q_buf);

#if DEBUG_DEQUANT
    int rowIdx_reg = (get_coreid() & 0xF);
    int colIdx_reg = (get_coreid() >> 16);
    if(colIdx_reg == 0 && rowIdx_reg == 2)
    {
        chess_report(q_buf[0]);
        chess_report(q_buf[2]);
        chess_report(quant_en);
    }
#endif

    if(qdqprm->q_float_type == uniop_qdq_param::FloatType::FLOAT32)
    {
        q<float, int16, 0, 32>((float*) matA, (float*) q_buf, (int16*) output, q_krn_param, quant_en);
    }
    else
    {
        q_float16_to_int16_v32((QDQFloatType*) matA, (float*) q_buf, (int16*) output, q_krn_param, quant_en);
    }
}
#endif