/*  (c) Copyright 2019 - 2025 Xilinx, Inc. All rights reserved.

    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.

    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.

    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.

    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __RESIZE_NEAREST_IMPL_H__
#define __RESIZE_NEAREST_IMPL_H__

#include "aie_api/aie.hpp"
#include "aie_api/utils.hpp"
// #include "resize_nearest.hpp"
#include "access_helpers.hpp"
#include "common.hh"

template<unsigned ilr, unsigned olr, typename Ti, typename Tw, typename To>
void resize_nearest_impl
(
    Ti * in0,
    Tw * in1,
    To * restrict out,
    const ResizeNearestParams & param
) {
    constexpr unsigned gran = 32;
    Tw * wts_x_ptr = (Tw* ) in1 + param.wts_x_offset;
    Tw * wts_y_ptr = (Tw* ) in1 ;
    dims_3d_t dimsW(param.num_wi_c64,0,param.dimsW.num0,param.dimsW.inc0,param.dimsW.inc1);
    dims_3d_t dimsA = param.dimsA.instantiate();
    unsigned step_xi = param.num_wi_c64==1 ? 64 : 32;
    To * restrict pO = (To * restrict) out;
    for ( unsigned j = 0; j < param.outer_loop; j++ )
    chess_prepare_for_pipelining
    chess_loop_range( 3, )
    {
        Ti * restrict in_ptr = in_ptr = byte_incr(in0, param.step_yi*wts_y_ptr[j]);
        for ( unsigned i = 0; i < param.inner_loop; i++ )
        chess_prepare_for_pipelining
        chess_loop_range( ilr, )
        {
            unsigned idx = *wts_x_ptr;
            aie::vector<Ti,gran> load_vec = aie::load_v<32>(in_ptr + step_xi*idx);
            aie::store_v(pO, load_vec); pO+=gran;
            wts_x_ptr = add_3d_byte( wts_x_ptr, dimsW);
            in_ptr = add_3d_byte( in_ptr, dimsA);
        }
    }

}

#endif // __RESIZE_NEAREST_IMPL_H__