#ifndef __RESIZE_NEAREST_WRAPPER_CC__
#define __RESIZE_NEAREST_WRAPPER_CC__
#include "resize_nearest_impl.hpp"

void run_resize_nni_a8(KernelArgs& args)
{
    ResizeNearestParams* resize_layer_params = static_cast<ResizeNearestParams*>(args.params_data);
    int8* ifm = static_cast<int8*>(args.s2mm_ch0_port->data());
    int16* wgt = static_cast<int16*>(args.s2mm_ch1_port->data());
    int8* ofm = static_cast<int8*>(args.mm2s_ch0_port->data());
    /*
    ilr possible values [1, 4, 8]
    olr possible values [1, 2, 3]
    No recomendation for the values to be set from kernel spec.
    For now setting to 8 and 3 by refering to AIE_SOL unit test.
    */
    unsigned const ilr = 8;
    unsigned const olr = 3;
    resize_nearest_impl<ilr,olr>(ifm, wgt, ofm, *resize_layer_params);
}

#endif // __RESIZE_NEAREST_WRAPPER_CC__