#ifndef __COPY_FP16x16_WRAPPER_CC__
#define __COPY_FP16x16_WRAPPER_CC__

#include "copy_kernel.hpp"

static int call_cnt = 0;
void run_copy_fp16x16(KernelArgs& args) 
{
    copy_layer_param* layer_params = (copy_layer_param*)args.params_data;

    int8_t* matA   = reinterpret_cast<int8_t*>(layer_params->input_addr); 
    int8_t* output = reinterpret_cast<int8_t*>(layer_params->output_addr);

    int subv_num_elem = layer_params->num_elem_subv; // * 32; // subv_num_rows * subv_num_cols;

    int ifmbytes = layer_params->ifmbytes;
    int ofmbytes = layer_params->ofmbytes;
    
    v16float16* pIn  = (v16float16*) matA;    
    v16float16* pOut = (v16float16*) output;

    if(ifmbytes==2 and ofmbytes==2)
    {
        uint16_t* pIn16  = (uint16_t*) matA;    
        uint16_t* pOut16 = (uint16_t*) output;
        for(int i = 0;  i < subv_num_elem; i++)
        {
            pOut16[i] = pIn16[i];
        }
    }
    else if(ifmbytes==2 and ofmbytes==4)
    {
        uint16_t* pIn16  = (uint16_t*) matA;    
        uint32_t* pOut32 = (uint32_t*) output;
        for(int i = 0;  i < subv_num_elem; i++)
        {
            pOut32[i] = (pIn16[i]) + (0x43bb << 16);
        }
    }
    else if(ifmbytes==4 and ofmbytes==2)
    {
        // Perform "Extract every-other 2 bytes" to verify
        uint32_t* pIn32  = (uint32_t*) matA;    
        uint16_t* pOut16 = (uint16_t*) output;
        for(int i = 0;  i < subv_num_elem; i++)
        {
            pOut16[i] = (pIn32[i] & 0x0000FFFF); 
        }
    }
    else if(ifmbytes==4 and ofmbytes==4)
    {
        uint32_t* pIn32  = (uint32_t*) matA;    
        uint32_t* pOut32 = (uint32_t*) output;
        for(int i = 0;  i < subv_num_elem; i++)
        {
            pOut32[i] = pIn32[i];
        }
    }

    /*if(call_cnt==1 and colIdx_reg == 0 and rowIdx_reg == 4)
    {
        v16uint16* pOut2 = (v16uint16*) pIn16;
        for(int i = 0;  i < subv_num_elem/16; i++)
        {
            chess_report(pOut2[i]);
        }
        chess_report(0xFFFF);
    }
    call_cnt++;*/
}


#endif