# Run python lint
packages="tiler scheduler scheduler/conv scheduler/gap dataflowtest graph buildtest buildscripts utils graph_partitioner HW_requirements aie4_bench"
modules="build_aie4.py"
flake8_args="--max-line-length=199"
pylint_args="--max-line-length=199 --disable=C0103,R0902,R0903,R0914,R0913,R0917,R0915,C0302,R0911,R0912,R0801,W0102,E1121"
mypy_args="--disallow-untyped-defs"
run_flake8="flake8 $flake8_args $packages $modules"
run_pylint="pylint $pylint_args $packages $modules"
run_mypy="mypy $mypy_args $packages $modules"
if [ -z "$1" ] || [ "$1" = "py" ]; then
    if echo $run_flake8 && $run_flake8; then
        echo "✅ Flake8 passed!"
    else
        echo "❌ Flake8 failed!"
        exit 1
    fi

    pylint_output_file=$(mktemp)
    echo $run_pylint && $run_pylint | tee $pylint_output_file
    if grep -q "R0401: Cyclic import" $pylint_output_file; then
        echo "❌ Circular imports found!"
        exit 1
    fi
    rm -rf $pylint_output_file

    echo $run_mypy && $run_mypy
fi

# Run c++ lint
clangtidy="/tools/batonroot/rodin/engkits/lnx64/llvm+clang8.0.0/bin/clang-tidy"
sources="host/*.hpp"
checks="*,\
-abseil*,\
-altera*,\
-android*,\
-boost*,\
-fuchsia*,\
-google*,\
-llvm*,\
-zircon*,\
-hicpp-deprecated-headers,\
-modernize-deprecated-headers,\
-misc-non-private-member-variables-in-classes,\
-cppcoreguidelines-pro-bounds-array-to-pointer-decay,\
-cppcoreguidelines-avoid-c-arrays,\
-hicpp-no-array-decay,\
-cppcoreguidelines-pro-type-vararg,\
-cppcoreguidelines-avoid-magic-numbers,\
-readability-magic-numbers,\
-cert-msc30-c,\
-cert-msc50-cpp,\
-hicpp-signed-bitwise"
warnings="-Wall -Wextra -Wpedantic -Wconversion"
if [ -z "$1" ] || [ "$1" = "cpp" ]; then
    for source in $sources; do
        run_clangtidy="$clangtidy $source -checks=$checks -- -Ihost -std=c++11 $warnings"
        echo $run_clangtidy && $run_clangtidy
    done
fi
