#!/bin/bash
set -e  # Exit on error
set -o pipefail  # Catch errors in pipes

# Get the directory where this script is located
SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

# Change to script directory
cd "$SCRIPT_DIR"
echo "Running pytests in directory: $(pwd)"

# Activate virtual environment if it exists
if [ -f "settings.sh" ]; then
    source settings.sh
fi

if [ -d "env" ] && [ -f "env/bin/activate" ]; then
    source env/bin/activate
fi

# Run pytest with exit code propagation
# This will run:
# 1. Unit tests in graph/tests, tiler/, scheduler/, utils/
# 2. Doctests in graph/ modules (via --doctest-modules in pytest.ini)
python -m pytest "$@" graph/ tiler/ scheduler/ utils/

# Run dma tests
python -m pytest -m dma buildtest