"""Script to run HW_test with user-defined arguments."""
import os
import argparse
from HW_requirements.aie4_test_script import HW_test
from utils.build_utils import set_datatype
CURRDIR = os.path.dirname(os.path.abspath(__file__))
HW_req = os.path.join(CURRDIR, 'HW_requirements')


def main():
    """Main function to parse arguments and run HW_test"""
    parser = argparse.ArgumentParser(description="Run HW_test with user-defined arguments.")

    parser.add_argument(
        "--out_dir",
        type=str,
        default=None,
        help="Path to WAIC output directory"
    )

    parser.add_argument(
        "--host",
        type=str,
        default="10.228.200.87",
        help="Host IP for HW_test"
    )

    parser.add_argument(
        "--perf_testing",
        action="store_true",
        help="Enable performance testing mode"
    )

    parser.add_argument(
        "--golden_io",
        type=str,
        default=None,
        help="Path to golden IO directory (optional)"
    )
    parser.add_argument(
        "--dtype",
        type=str,
        default="int16",
        choices=["int16", "int8", "float16", "uint16"],
        help="Data type for the HW test"
    )
    parser.add_argument(
        "--filter",
        action="append",
        help="Wildcard filter for selecting folders (supports fnmatch, e.g. --filter \"*MatMul*\")"
    )
    mode_group = parser.add_mutually_exclusive_group()
    mode_group.add_argument(
        "--op", "-operator", dest="mode", action="store_const", const="op",
        help="Operator mode (default). Expects bins in <folder>/hw_package/."
    )
    mode_group.add_argument(
        "--sg", "-subgraph", dest="mode", action="store_const", const="sg",
        help="Subgraph mode. Expects bins directly in each subfolder."
    )
    parser.set_defaults(mode="op")

    parser.add_argument(
        "--debug",
        action="store_true",
        help="Enable debug mode"
    )

    parser.add_argument(
        "--ml-timeline", "--ml_timeline",
        action="store_true",
        help="Enable ML Timeline profiling."
        )

    parser.add_argument(
        "-fp16", "--is_qdq_fp16",
        type=bool, default=True,
        help="QDQ datatpye is FP16 or BF16? (Default -> False (QDQ DType is BF16))"
        )

    args = parser.parse_args()

    # If user didn't pass paths, assign defaults based on script location
    curr_dir = os.path.dirname(os.path.abspath(__file__))
    out_dir = args.out_dir or os.path.join(curr_dir, "Output")

    # Set env variable for toggling ML Timeline
    os.environ["ML_TIMER_LOG_LEVEL"] = "1" if args.ml_timeline else "0"

    # Set Env Variable for QDQ Data Type
    set_datatype(args.is_qdq_fp16)

    print(f"WAIC_out = {out_dir}")
    print(f"HW_req   = {HW_req}")
    print(f"Host     = {args.host}")
    print(f"Perf     = {args.perf_testing}")
    print(f"Dtype    = {args.dtype}")
    print(f"Mode     = {args.mode}")

    HW_test(
        out_dir,
        HW_req,
        host=args.host,
        perf_testing=args.perf_testing,
        golden_io=args.golden_io,
        dtype=args.dtype,
        mode=args.mode,
        filter_patterns=args.filter,
        debug=args.debug,
    )


if __name__ == "__main__":
    main()
