# settings.ps1

# Use $PSScriptRoot for "this script's directory"
$repoRoot = $PSScriptRoot
$pwdPath  = (Get-Location).Path
$sep      = [IO.Path]::PathSeparator

function Prepend-Paths([string]$envVarName, [string[]]$paths) {
    # keep only existing, unique paths
    $clean = $paths | Where-Object { $_ -and (Test-Path $_) } | Select-Object -Unique
    if (-not $clean -or $clean.Count -eq 0) { return }

    $newPrefix = ($clean -join $sep)

    $existingItem = Get-Item -Path "Env:$envVarName" -ErrorAction SilentlyContinue
    $existing = if ($existingItem) { $existingItem.Value } else { "" }

    if ([string]::IsNullOrEmpty($existing)) {
        $value = $newPrefix
    } else {
        $value = "$newPrefix$sep$existing"
    }

    [Environment]::SetEnvironmentVariable($envVarName, $value, "Process")
}

# PYTHONPATH
Prepend-Paths PYTHONPATH @(
    $pwdPath
    (Join-Path $pwdPath "dmacompiler")
    (Join-Path $pwdPath "tiler")
    (Join-Path $pwdPath "scheduler")
    (Join-Path $pwdPath "kernel")
    (Join-Path $pwdPath "kernel\common")
)

# MYPYPATH
Prepend-Paths MYPYPATH @(
    $pwdPath
    (Join-Path $pwdPath "dmacompiler")
    (Join-Path $pwdPath "tiler")
    (Join-Path $pwdPath "scheduler")
    (Join-Path $pwdPath "kernel")
    (Join-Path $pwdPath "kernel\common")
)

# AIE4_ROOT_DIR
$env:AIE4_ROOT_DIR = $repoRoot

# Set aie-rt ENV Path
$env:XAIENGINE_PATH = Join-Path $repoRoot "dmacompiler\aie-rt\build_windows\include"
$env:XAIENGINE_HEADER_PATH = Join-Path $repoRoot "dmacompiler\aie-rt\build_windows\include\xaiengine"
$env:LIBRARY_PATH_XAIENGINE = Join-Path $repoRoot "dmacompiler\aie-rt\build_windows\Debug"

# To ensure consistent Conv/GeMM tiling across run
$env:PYTEST_CURRENT_TEST = "1"

# For .exe to find the DLL at runtime
Prepend-Paths PATH @($env:LIBRARY_PATH_XAIENGINE)


Write-Host "Environment configured for Windows."
