#!/bin/bash
export AIE4_ROOT_DIR=$(dirname $(realpath "${BASH_SOURCE[0]}"))
export PYTHONPATH="$AIE4_ROOT_DIR"${PYTHONPATH:+:$PYTHONPATH}
export PATH=/tools/batonroot/rodin/engkits/lnx64/gcc-12.3.0/bin/${PATH:+:$PATH}
export LD_LIBRARY_PATH=/tools/batonroot/rodin/engkits/lnx64/gcc-12.3.0/lib64${LD_LIBRARY_PATH:+:$LD_LIBRARY_PATH}

if [[ "$(uname -s)" != "CYGWIN"* && "$(uname -s)" != "MINGW"* && "$(uname -s)" != "MSYS"* && "$(uname -o 2>/dev/null)" != "Msys" ]]; then
  # Set environment variables
  export TOOLS_VERSION="9999.0_PRIME_1124_1928"

  export XILINX_VITIS="/proj/primebuilds/${TOOLS_VERSION}/installs/lin64/HEAD/Vitis"
  export XILINX_VITIS_AIETOOLS="/proj/primebuilds/${TOOLS_VERSION}/installs/lin64/HEAD/Vitis/aietools"

  # Source environment setup scripts
  source "${XILINX_VITIS_AIETOOLS}/scripts/aietools_env.sh"
  source "${XILINX_VITIS}/settings64.sh"

  # Set license environment variables
  export XILINXD_LICENSE_FILE="2100@aiengine-eng"
  export LM_LICENSE_FILE="1757@xsjlicsrvip"

  # AIE-RT Linux build locations
  export AIE_RT_LINUX_BUILD_DIR="${AIE4_ROOT_DIR}/dmacompiler/aie-rt/build_linux"
  export AIE_RT_LINUX_LIB_DIR="${AIE_RT_LINUX_BUILD_DIR}"
  export AIE_RT_LINUX_INCLUDE_DIR="${AIE_RT_LINUX_BUILD_DIR}/include"
  export LD_LIBRARY_PATH="${AIE_RT_LINUX_LIB_DIR}:${LD_LIBRARY_PATH:-}"

  # To ensure consistent Conv/GeMM tiling across run
  export PYTEST_CURRENT_TEST=1

  echo "Linux environment setup complete."
else
  echo "Skipped Linux-only environment setup on Windows."
fi
