'''Remove temp files from output directory'''
import os
import shutil
import argparse

ALLOWED_FILES = {"aie4_dma.cpp", "dma.hpp", "graph.hpp", "super.cc", "super.hh"}
HW_DIR = "hw_package"


def clean_folder(root_path: str, include_root: bool = False) -> None:
    '''Clean folder'''
    root_path = os.path.abspath(root_path)
    for dirpath, dirnames, filenames in os.walk(root_path, topdown=True):
        if HW_DIR in dirnames:
            dirnames.remove(HW_DIR)
        rel = os.path.relpath(dirpath, root_path)
        is_root = rel == "."
        if is_root and not include_root:
            continue
        for d in list(dirnames):
            p = os.path.join(dirpath, d)
            print(f"DELETE DIR: {p}")
            if os.path.islink(p) or not os.path.isdir(p):
                os.remove(p)
            else:
                shutil.rmtree(p, ignore_errors=True)
        dirnames[:] = []
        for f in filenames:
            if f not in ALLOWED_FILES:
                p = os.path.join(dirpath, f)
                print(f"DELETE FILE: {p}")
                os.remove(p)


if __name__ == "__main__":
    ap = argparse.ArgumentParser()
    ap.add_argument("path")
    ap.add_argument("--include-root", action="store_true")
    args = ap.parse_args()
    clean_folder(args.path, include_root=args.include_root)
